function  [g_1,g_history ]  = dvde_hinf( A , B , Bw , C , Q , R , Rw , Qf , gamma_2, N , K_history_vec , yr , i);

%
%DVDE Discrete-time Vector Differential Equation Solver for H infinity control
%

%------------------------
% system dimension
%------------------------
n = size(A,1);

%------------------------
% boundary condition
%------------------------

g_N = -C'*Qf*yr(:,i+N);
g_history = g_N;
g_j = g_N;

%------------------------
% solve Vector Difference Equation
%------------------------

for j = (N-1) : -1 : 1
   	K_j = vec2mtx(K_history_vec(:,(N-1)-j+1));
      Lambda = eye(n) + K_j * ( B*inv(R)*B' - 1/gamma_2 * Bw * inv(Rw) * Bw' ) ; 
   	g_j = A'*inv(Lambda)*g_j - C'*Q*yr(:,i+j);   
	g_history = [g_history g_j];
end
%------------------------
% time-varying feed-forward gain g(1) for H infinity RHTC
%------------------------
[m,n] = size(g_history);
g_1 = g_history(:,n);

return;