function  [mtx ]  = vec2mtx(vec , num_col );

%
%VEC2MTX  Vector of Length n^2 to Square Matrix of Order n 
%
%VEC2MTX converts a column (low) vector, VEC = [a;b;c;...], 
%where the vector must be of length n^2, to a matrix of 
%order n, MTX = [A B C ...], where A = [a;b;c;...], 
%B, C, ... are 1 column vectors of low n.
%The conversion is performed in column-oriented method.

%See also MTX2VEC

%------------------------
% verify the input (vector ? or matrix ?)
%------------------------

[n,m] = size(vec);
mtx = [];

if nargin == 2 
   	for column=1:1:n/num_col
    		mtx = [mtx vec( num_col *(column-1)+1 : num_col*column,1)];
 	end
 	return ; 
end

   
if (~(m ==  1 | n == 1))
   disp('The input must be a column or row vector');   
   return
end

%------------------------
% verify the vector (the length is n^2 ?)
%------------------------
N = sqrt(length(vec));
N_int = round(N);
if (~(N == N_int))
   disp('The input vector must be of length n^2');   
   return
end

%------------------------
% if the vector is a row vector, convert it to a column vector
%------------------------
if (n == 1)
  vec = vec';
end

%------------------------
% convert the vector to a matirix in column-oriented method
%------------------------
mtx = [];

for column = 1:N      
    mtx = [mtx vec((column-1)*N+1 : column*N)];
end

return
