%------------------------------------------
%  Demonstration of deadbeat filter. 
%------------------------------------------
clc;
clear all;

%------------------------
% System parameters
%------------------------
A = [0 1 0 1 ; 0 0 1 0; 0 0 0 0; 0 0 0 1] ;
B = 0 ;
C = [1 0 0 0; 0 1 0 0] ;
G = 0.02*eye(4) ;
Q = 0.2*eye(4) ;
R = 0.4*eye(2) ;

%------------------------
% Simulation parameters
%------------------------
N_sample = 250 ;
N_horizon = 15 ;
noise = 1; 
intial_state= [1 7 10 2]' ;
intial_omega_state = [2 3 4]' ;
x = intial_state ;
omega_hat = intial_omega_state ;

%------------------------
% Parameters for deadbeat filter
%------------------------
N = [0 0 1  0 ; 0 1 0 0] ;
L1 = [0 -1;1 0; 0 0] ;
L = [0 0 1; 0 1 0] ;
A_o = [0 0 0; 1 0 0; 0 0 0] ;

%------------------------
% Get FIR filter for singular A
%------------------------
[B_tilde , C_tilde , G_tilde , H_mtx] =  MakeBigMatrices_gen(A,B,C,G,Q,R,N_horizon) ;


%------------------------
% Simulation starts here !
%------------------------
for i = 1 : N_sample-1
	if noise == 0
		x = A*x ;	   
		y  =   C*x ;
	else 
      	x = A*x + G * rand(4,1)*sqrt(0.2);
	   	y  =   C*x +  1* randn(1,1)*sqrt(0.4);
   	end
   	measurements(2*i-1:2*i) = y';
   	z = N * x;  % Real partial estimate

	if ( i < N_horizon)
     		z_hat  = N * x; 
     		z_hat_FIR = N * x;
  	else  %  Relation between omega_hat  and z_hat (Observer)
     		omega_hat = A_o * omega_hat + L1 * y;
		z_hat = L * omega_hat;
   		%FIR filter   
     		x_hat = H_mtx * measurements(2*i-2*N_horizon+1:2*i)';
	  	z_hat_FIR = N * x_hat;
     
     		estimated_state_observer(:,i+1) = z_hat;
     		estimated_state_FIR(:,i+1) = z_hat_FIR;
     		real_state(:,i+1) = z;
     		real_state_x(:,i+1) = x;
     		estimated_state_FIR_x(:,i+1) = x_hat;     
	end
end

%------------------------
% Simulation results are shown here.
%------------------------
axis([13 55 -1 7]) ;
grid ;
plot( 1:N_sample , real_state_x(1,:) ,'k' ,1:N_sample ,estimated_state_FIR_x(1,:),'b.',1:N_sample , estimated_state_observer(2,:),'r') ;
title('Estimation error') ;
xlabel('Time') ;
legend( 'Real state' , 'FIR' , 'IIR' ) ;