%------------------------------------------
%  Demonstration of tracking controls
%------------------------------------------

clc; 
clear all;
N_sample = 64;

%------------------------
% System parameters
%------------------------

A = [    0.0134    0.8118    0.1238;    0.0046    0.7704    0.0961;    0.9878    0.9033    0.5515 ];
B = [0.456  ; 0.018  ; 0.821];

N_order_A = size(A, 1);
N_order_B = size(B, 2);

C = B;

for i = 1 : N_order_A - 1  
    C = [C A^(i)*B];
end

Q = eye(N_order_A, N_order_A) * 100;
R = eye(N_order_B, N_order_B);

Period = 20;

x_1 = [ 0, ones(1, N_sample-1) ];
x_2 = [ zeros(1, 5), 2*ones(1, N_sample-5) ];
x_3 = [ zeros(1, 10), 3*ones(1, N_sample-10) ];

ref_x = [ x_1; x_2; x_3 ];
track_x = zeros(N_order_A, N_sample);
track_x(:, 1) = ref_x(:, 1);

%------------------------
% Variables for saving data
%------------------------

S_temp = zeros(N_order_A, N_order_A);
g_temp = eye(N_order_A, N_order_A);
P_temp = zeros(N_order_A, N_order_A);

M_temp = zeros(N_order_A, 1);
N_temp = zeros(N_order_A, 1);

S = zeros(N_order_A, N_order_A * N_sample);
g = zeros(N_order_A, N_order_A * N_sample);
P = zeros(N_order_A, N_order_A * N_sample);

M = zeros(N_order_A, N_sample);
N = zeros(N_order_A, N_sample);

%------------------------
% Initial conditions
%------------------------

S( : , N_order_A * N_sample - ( N_order_A - 1 ) : N_order_A * N_sample ) = S_temp;
g( : , N_order_A * N_sample - ( N_order_A - 1 ) : N_order_A * N_sample ) = g_temp;
P( : , N_order_A * N_sample - ( N_order_A - 1 ) : N_order_A * N_sample ) = P_temp;

M( : , N_sample ) = M_temp;
N( : , N_sample ) = N_temp;

%------------------------
% Main loop : backward
%------------------------
for i = 1 : N_sample-1
    
    P_temp = P_temp - g_temp' * B * inv( B' * S_temp * B + R ) * B' * g_temp;
    N_temp = N_temp - g_temp' * inv(eye(N_order_A, N_order_A) + B * inv(R) * B' * S_temp) * B * inv(R) * B' * M_temp;
    M_temp = A' * M_temp - A' * S_temp * inv(eye(N_order_A, N_order_A) + B * inv(R) * B' * S_temp) * B * inv(R) * B' * M_temp - Q * ref_x(:, N_sample - i);
    
    K_temp = inv( B' * S_temp * B + R ) * B' * S_temp * A;
    S_temp = A' * S_temp * ( A - B * K_temp ) + Q;
    g_temp = ( A - B * K_temp )' * g_temp;
    
    S( : , N_order_A * ( N_sample -  i ) - ( N_order_A - 1 ) : N_order_A * ( N_sample -  i ) ) = S_temp;
    g( : , N_order_A * ( N_sample -  i ) - ( N_order_A - 1 ) : N_order_A * ( N_sample -  i ) ) = g_temp;
    P( : , N_order_A * ( N_sample -  i ) - ( N_order_A - 1 ) : N_order_A * ( N_sample -  i ) ) = P_temp;
    
    M( : , N_sample - i ) = M_temp;
    N( : , N_sample - i ) = N_temp;    
            
end

%------------------------
% Main loop : forward
%------------------------
temp = inv(P(:, 1:N_order_A)) * (ref_x(:, N_sample) - g(:, 1:N_order_A)' * track_x(:, 1) - N(:, 1));
for i = 1 : N_sample-1
    
    u_temp = -inv(B' * S(:, N_order_A * i + 1:N_order_A * i + N_order_A) * B + R) * B' * (S(:, N_order_A * i + 1:N_order_A * i + N_order_A) * A * track_x(:, i) + g(:, N_order_A * i + 1:N_order_A * i + N_order_A) * temp + M(:, i+1));
    track_x(:, i+1) = A * track_x(:, i) + B * u_temp;  
    
end
Q_f = [ 1 0 0; 0 1 0; 0 0 1 ] * 10;
Q_f_inv = zeros(N_order_A, N_order_A);

X_ref_tilde = ref_x(:, 1);

for i = 2 : N_sample
    X_ref_tilde = [X_ref_tilde; ref_x(:, i)];
end

B_diag = B;
Q_diag = Q;
R_diag = R;

I_diag = eye(N_order_A, N_order_A);

A_c_tilde = eye(N_order_A, N_order_A);
A_r_tilde = eye(N_order_A, N_order_A);
A_l_triangle = zeros(N_order_A, N_order_A);

for i = 1 : N_sample - 1
    A_c_tilde = A_c_tilde * A ;
    A_c_tilde = [eye(N_order_A, N_order_A); A_c_tilde] ;
    if i > 1
        A_l_triangle = [A_l_triangle zeros(size(A_l_triangle, 1), N_order_A)] ;            
    end
    A_l_triangle = [A_l_triangle; A_r_tilde] ;
    A_r_tilde =  A * A_r_tilde ;
    A_r_tilde = [A_r_tilde eye(N_order_A, N_order_A)] ;
end

for i = 1 : N_sample - 2
    B_diag = daug(B_diag, B) ;
    Q_diag = daug(Q_diag, Q) ;
    R_diag = daug(R_diag, R) ;   
    I_diag = daug(I_diag, eye(N_order_A, N_order_A)) ;
end

Q_hat_diag = daug(Q_diag, Q_f);
Q_hat_diag_tilde = daug(Q_diag, eye(N_order_A, N_order_A));
I_hat_diag = daug(I_diag, Q_f_inv);


Temp = Q_hat_diag_tilde * A_l_triangle * B_diag * inv(R_diag) * B_diag' * A_l_triangle' + I_hat_diag;
U = -inv(R_diag) * B_diag' * A_l_triangle' * inv(Q_hat_diag_tilde * A_l_triangle * B_diag * inv(R_diag) * B_diag' * A_l_triangle' + I_hat_diag) * Q_hat_diag_tilde * (A_c_tilde * ref_x(:, 1) - X_ref_tilde);

X = A_c_tilde * ref_x(:, 1) + A_l_triangle * B_diag * U;
track_x_one = zeros(N_order_A, N_sample);

for i = 1 : N_sample    
    track_x_one(:, i) = X(N_order_A * (i - 1) + 1 : N_order_A * (i - 1) + N_order_A);
end
    

%------------------------
% Simulation results are shown here.
%------------------------
figure(1);
plot( 1:N_sample , ref_x(1, :) , 'k' , 1:N_sample , track_x(1, :) , 'r-' , 1:N_sample , track_x_one(1, :) , 'b--');
legend( 'Reference', 'Recursive', 'Batch' );
xlabel('Time');
ylabel('Magnitude');
title('First state');
grid on;

figure(2);
plot( 1:N_sample , ref_x(2, :) , 'k' , 1:N_sample , track_x(2, :) , 'r-' , 1:N_sample , track_x_one(2, :) , 'b--');
legend( 'Reference', 'Recursive', 'Batch' );
xlabel('Time');
ylabel('Magnitude');
title('Second state');
grid on;

figure(3);
plot( 1:N_sample , ref_x(3, :) , 'k' , 1:N_sample , track_x(3, :) , 'r-' , 1:N_sample , track_x_one(3, :) , 'b--');
legend( 'Reference', 'Recursive', 'Batch' );
xlabel('Time');
ylabel('Magnitude');
title('Third state');
grid on;
