%-------------------------------------
% Maximal Admissible Set Example
%-------------------------------------

%% System Description
A= [1     0.2212;
    0     0.7788];
B = [0.0288;0.2212];
G =[1 0; 0 1; 1.5 1];

[n,n]=size(A);
[n,m]=size(B);

%% Input Constraint: -0.5 <= u <= 0.5
%% State Constraint: -1.5 <= x1 <= 1.5, -0.3 <= x2 <= 0.3
u_max=0.5;
u_min=-0.5;
x_lim = [1.5;0.3];
E = [1;-1];
G = [1 0;-1 0;0 1;0 -1];
e = [u_max;-u_min];
g = [1.5; 1.5;0.3;0.3];

[nd_r, nd_c] = size(E);
[ng_r, ng_c] = size(G);

%% Weighting Matrix
Q = 1*eye(size(A));
R = 1;

%% Terminal Weighting matrix
P = dareiter(A,B,R,Q);

%% Optimal LQ feedback gain
K = -inv(R+B'*P*B)*B'*P*A;
A_cl = A+B*K;

%% P can also obtained in an alternative way as follows:
P2=dlyap(A_cl',Q+K'*R*K);

Phi = [E*K;G];
phi = [e;g];

%% Obtain t_star, which is the smallest integer 
%% defining the set O_inf
t_star = get_t(A_cl,eye(size(A_cl)), Phi, phi, 500);

region = mas(A_cl, Phi, phi, t_star);
plot ( region(1,:) , region(2,:) , 'r.', region(1,:),region(2,:),'k-');
xlabel('x_1');
ylabel('x_2');
title('Maximal admissible set');
grid;