function t = get_t(A,C,E,e,max_iter)
%
%  This function computes the maximum time t for the maximal output
%  admissible sets
%  
%                      E*C*A^N*x <= e
%    <input>
%    A : system matrix
%    C : output matrix
%    E, e : matrix and vector defining constraint set which the output of the system should satisfy
%    max_iter : maximum iteration number, default value = 100
%
%   <output>
%    t : maximum time for defining the maximal output admissible sets
% 
%   <Example>
%
%        x(t+1)=Ax(t), y(t)=Cx(t)
%        Output constraint   O;   -1 <=y1 <=1,  -1 <=y2 <=1
%
%        A =    [0.9739    0.0142; -0.0715    1.0152];
%        C = [-1   1;2  -1];
%        E =[1 0;-1 0;0 1;0 -1]; e=[1;1;1;1]; max_iter=100;
%
%
%
if (nargin==4)
   max_iter = 100;
end

%----------------------------------
%  Let's check that all the eigenvalues
%  of A are inside the unit disk
%----------------------------------
lambda = eig(A);
lambda = abs(lambda);
max_eig = max(lambda);
if (max_eig>=1-1e-6),
   display('System matrix A should be stable');
   error('');
end

%---------------------------------
%  Let's check the number of constraint
%---------------------------------
[p,q] = size(E);

%---------------------------------
% We are now ready to find t*
%---------------------------------
t = -1;
flag = 0;
maximum = zeros(p,1);

clc;
S = []; B = []; 
while flag==0,
   home;
   t=t+1; 
   s = E*C*A^t;
   f  = E*C*A^(t+1);
   
   S=[S;s];
   B=[B;e];
   
   for i=1:p,
      [x,LAMBDA,info]=LP(-f(i,:)',S,B);      % Linear Programming
      if (info(1) ==  'u'),
         maximum(i) = e(i)+1; % This is for the continuation of the program
      elseif (info(1) == 'i'),
         disp('problem is infeasible');
         error('');
      else 
         maximum(i)=f(i,:)*x;  % x : maximum value
      end   
   end
   
   max_difference = min(e-maximum);
   if (max_difference>=0)
      flag=1;
   else 
      flag=0;
   end
   
   if t>max_iter,
      flag=1;
   end
end