/*
 * DynamicProcessor.java
 *
 * Created on 5 February 2002, 15:36
 */

package javanet.arch;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class DynamicProcessor implements javanet.arch.ConnectionProcessor {

	private java.net.Socket connection;
	
	/** Creates new DynamicProcessor */
    public DynamicProcessor(Socket connection) {
		this.connection = connection;
    }

	/**
	 * When an object implementing interface <code>Runnable</code> is used 
	 * to create a thread, starting the thread causes the object's 
	 * <code>run</code> method to be called in that separately executing 
	 * thread. 
	 * <p>
	 * The general contract of the method <code>run</code> is that it may 
	 * take any action whatsoever.
	 *
	 * @see     java.lang.Thread#run()
 */
	public void run()
	{
		synchronized (this.getClass()) {
			System.err.println(new Date()+": "+Thread.currentThread()+" running");
		}
		process(connection);
		synchronized (this.getClass()) {
			System.err.println(new Date()+": "+Thread.currentThread()+" exiting");
		}
	}
	
	public void process(java.net.Socket connection)
	{
		synchronized (this.getClass()) {
			System.err.println(new Date()+": "+Thread.currentThread() +" processing connection");
		}
		try {
			connection.close();
		} catch (IOException exc) {
			synchronized (this.getClass()) {
				System.err.println(new Date()+": "+Thread.currentThread());
				exc.printStackTrace(System.err);
			}
		}
	}
}
