/*
 * ListQueue.java
 *
 * Created on 4 February 2002, 11:19
 */

package javanet.arch;

import java.util.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class ListQueue implements Queue {
	private List	list = new LinkedList();
	private boolean	isTerminated = false;
	private int		waitCount = 0;

	
	/** Creates new ListQueue */
    public ListQueue() {
    }
	
	public synchronized void	enqueue(Object object) {
		list.add(object);
		notify();
	}
	
	public synchronized Object	dequeue() {
		return dequeue(0);
	}
	
	public synchronized Object dequeue(int timeout)
	{
		while (!isTerminated && list.isEmpty()) {
			long	startTime = System.currentTimeMillis();
			waitCount++;
			try {
				wait(timeout);
			} catch (InterruptedException exc) {
			}
			waitCount--;
			if (timeout > 0)
				timeout -= (int)(System.currentTimeMillis()-startTime);
			if (timeout < 0)
				return null;
		}
		return isTerminated ? null : list.remove(0);
	}
	
	public int waitCount() {
		return waitCount;
	}
	
	public synchronized void terminate()
	{
		isTerminated = true;
		notifyAll();
	}
	
}