/*
 * ListQueueProcessor.java
 *
 * Created on 5 February 2002, 15:17
 */

package javanet.arch;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class ListQueueProcessorTest extends java.lang.Object {

	/** Creates new ListQueueProcessor */
    public ListQueueProcessorTest() {
    }

    /**
    * @param args the command line arguments
    */
	public static void	main(String[] args) throws IOException {
		ServerSocket	server = new ServerSocket(1100);
		Queue			queue = new ListQueue();
		for (int i = 0; i < 16; i++)
			new Thread(new QueueProcessor(queue), "QueueProcessor-"+i).start();
		System.err.println(new Date()+": driver running");
		for (int i = 0; i < 32; i++) {
			new Thread(new Client("localhost",1100), "Client-"+i).start();
			try {
				Socket	connection = server.accept();
				queue.enqueue(connection);
			} catch (SocketException exc) {
				// server socket probably closed
//				if (!server.isOpen()) // needs JDK 1.4
				{
					System.err.println(exc);
					queue.terminate();
					break;
				}
			} catch (InterruptedIOException exc) {
				queue.terminate();
				break;
			} catch (IOException exc) {
				exc.printStackTrace();
			}
		}
		queue.terminate();
		System.err.println(new Date()+": driver exiting: activeCount="+Thread.currentThread().getThreadGroup().activeCount());
	}
	
	static class Client implements Runnable {
		String	host;
		int	port;
		
		Client(String host, int port)
		{
			this.host = host;
			this.port = port;
		}
		
		public void	run() {
			System.err.println(new Date()+": "+Thread.currentThread()+": running");
			try {
				Socket	socket = new Socket(host, port);
				socket.close();
			}
			catch (IOException exc) {
				System.err.println(new Date()+": "+Thread.currentThread());
				exc.printStackTrace(System.err);
			}
			System.out.println(new Date()+": "+Thread.currentThread()+": exiting");
		}
	}
}
