/*
 * MultiplexedTCPServer.java
 *
 * Created on 11 February 2002, 11:37
 */

package javanet.arch;

import java.io.*;
import java.net.*;
import java.nio.*;
import java.nio.channels.*;
import java.util.*;

class Attachment extends Thread
{
    ByteBuffer	readBuffer = ByteBuffer.allocate(8192);
    ByteBuffer	writeBuffer = ByteBuffer.allocate(8192);
    
    Attachment()
    {
	start();
    }
    
    public synchronized void	run()
    {
	for (;;)
	{
	    try
	    {
		wait();
	    }
	    catch (InterruptedException exc)
	    {
	    }
	    System.out.println("readReady: "+readBuffer);
	    writeBuffer = readBuffer.duplicate();
	}
    }
    
    synchronized void    readReady()
    {
	notify();
    }
}
/**
 *
 * @author  Administrator
 * @version 
 */
public class MultiplexedTCPServer implements java.lang.Runnable
{

    ServerSocketChannel serverChannel;
    Selector    selector;
    
    /** Creates new MultiplexedTCPServer */
    public MultiplexedTCPServer (int port) throws IOException
    {
	this.serverChannel = ServerSocketChannel.open();
	serverChannel.socket().bind(new InetSocketAddress(port));
	serverChannel.configureBlocking(false);
	selector = Selector.open();
	serverChannel.register(selector, serverChannel.validOps());
    }

    /**
     * When an object implementing interface <code>Runnable</code> is used
     * to create a thread, starting the thread causes the object's
     * <code>run</code> method to be called in that separately executing
     * thread.
     * <p>
     * The general contract of the method <code>run</code> is that it may
     * take any action whatsoever.
     *
     * @see     java.lang.Thread#run()
     */
    public void run ()
    {
	while (selector.isOpen())
	{
	    try
	    {
		System.out.println(new Date()+": selecting from "+selector.keys().size()+" registered channels");
		int	nSel = selector.select(60*1000);
		System.out.println(new Date()+": selected "+nSel+" ready keys");
		Set	readyKeys = selector.selectedKeys();
		synchronized(readyKeys)
		{
		    Iterator    it = readyKeys.iterator();
		    while (it.hasNext())
		    {
			SelectionKey    key = (SelectionKey)it.next();
			// 1.4RC1 Win32 remove following line ...
			it.remove();
			if (!key.isValid())
			    continue;
			System.out.println(new Date()+": "+key+" readyOps=0x"+Integer.toHexString(key.readyOps()));
			if (key.isAcceptable())
			    handleAcceptable(key);
			if (key.isReadable())
			    handleReadable(key);
			if (key.isWritable())
			    handleWritable(key);
		    }
		    if (nSel == 0)
		    {
			it = selector.keys().iterator();
			while (it.hasNext())
			{
			    SelectionKey	key = (SelectionKey)it.next();
			    Channel	channel = key.channel();
			    if (channel instanceof SocketChannel)
			    {
				System.out.println(new Date()+": timeout on "+channel+" - closing");
				channel.close();
			    }
			}
		    }
		}
	    }
	    catch (IOException exc)
	    {
		exc.printStackTrace();
	    }
	}
    }
    
    void    handleAcceptable(SelectionKey key)
    {
	try
	{
	    ServerSocketChannel	sch = (ServerSocketChannel)key.channel();
	    SocketChannel   ch = sch.accept();
	    if (ch != null)
	    {
		System.out.println("Accepted "+ch);
		ch.configureBlocking(false);
		ch.register(key.selector(),ch.validOps(), new Attachment());
	    }
	}
	catch (IOException exc)
	{
	    exc.printStackTrace();
	}
    }
    
    void    handleReadable(SelectionKey key)
    {
	try
	{
	    SocketChannel   ch = (SocketChannel)key.channel();
	    Attachment	    att = (Attachment)key.attachment();
	    if (att.readBuffer.hasRemaining())
	    {
		synchronized(att.readBuffer)
		{
		    int	count = ch.read(att.readBuffer);
		    System.out.println("read count="+count);
		    if (count < 0)
		    {
			key.interestOps(key.interestOps() & ~SelectionKey.OP_READ);
			System.out.println("Half-closing "+ch);
			ch.socket().shutdownInput();
		    }
		    else
			att.readReady();
		}
	    }
	}
	catch (IOException exc)
	{
	    exc.printStackTrace();
	}
    }
    
    void    handleWritable(SelectionKey key)
    {
	try
	{
	    SocketChannel   ch = (SocketChannel)key.channel();
	    Attachment	    att = (Attachment)key.attachment();
	    if (att.writeBuffer.hasRemaining())
	    {
		synchronized(att.writeBuffer)
		{
		    att.writeBuffer.flip();
		    int	count = ch.write(att.writeBuffer);
		    System.out.println("write count="+count);
		    att.writeBuffer.compact();
		}
	    }
	    else
		System.out.println("nothing to write on "+ch);
//	    if (ch.socket().isInputShutdown())
	    if ((key.interestOps() & SelectionKey.OP_READ) == 0)
	    {
		System.out.println("Closing "+ch);
		ch.close();
	    }
	}
	catch (IOException exc)
	{
	    exc.printStackTrace();
	}
    }

    public static void	main(String[] args) throws IOException
    {
	int port = args.length > 0 ? Integer.parseInt(args[0]) : 1100;
	MultiplexedTCPServer	mts = new MultiplexedTCPServer(port);
	new Thread(mts).start();
	System.out.print("Presss <ENTER> to exit ...");
	System.in.read();
	mts.selector.close();
	mts.serverChannel.close();
    }
}
