/*
 * SocketAcceptingQueue.java
 *
 * Created on 4 February 2002, 11:23
 */

package javanet.arch;

import java.io.*;
import java.net.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class SocketAcceptingQueue implements Queue
{
	private ServerSocket server;
	private boolean	isTerminated = false;
	private int	waitCount = 0;
	
	/** Creates new SocketAcceptingQueue */
    public SocketAcceptingQueue(ServerSocket server) {
		this.server = server;
    }

	public void enqueue(Object object)
	{
		throw new UnsupportedOperationException("enqueue");
	}

	public synchronized Object dequeue()
	{
		return dequeue(0);
	}
		
	public synchronized Object dequeue(int timeout)
	{
		if (!isTerminated)
		{
			try
			{
				waitCount++;
				server.setSoTimeout(timeout);
				return server.accept();
			}
			catch (SocketException exc) {}			// server socket closed: expected
			catch (InterruptedIOException exc) {}	// timeout: expected
			catch (IOException exc)
			{
				exc.printStackTrace();
			}
			finally
			{
				waitCount--;
			}
		}
		return null;
	}
	
	public int waitCount()
	{
		return waitCount;
	}
	
	public void terminate()
	{
		isTerminated = true;
	}
	
}
