/*
 * BroadcastClient.java
 *
 * Created on 7 June 2002, 15:09
 */

package javanet.mcast;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 * @author  Administrator
 * @version 
 */
public class BroadcastClient
{
	DatagramSocket	socket;
	byte[]	buffer = new byte[8193];

	/** Creates new BroadcastClient */
    public BroadcastClient (InetAddress address,int port) throws IOException
	{
		this.socket = new DatagramSocket();
		DatagramPacket	packet = new DatagramPacket(buffer,buffer.length-1,address,port);
		socket.send(packet);
		System.out.println(new Date()+" sent: now receiving replies");
		socket.setSoTimeout(30*1000);
		for (;;)
		{
			try
			{
				packet.setLength(buffer.length);
				socket.receive(packet);
				System.out.println(new Date()+" received reply from "+packet.getAddress());
			}
			catch (InterruptedIOException exc)
			{
				System.out.println(exc);
				break;
			}
		}
    }

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws IOException
	{
		InetAddress	address = InetAddress.getByName(args[0]);
		int	port = Integer.parseInt(args[1]);
		new BroadcastClient(address,port);
    }

}
