/*
 * MulticastReceiver.java
 *
 * Created on 19 June 2002, 15:43
 */

package javanet.mcast;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class MulticastReceiver implements Runnable
{
	MulticastSocket	socket;

	/** Creates new MulticastReceiver */
    public MulticastReceiver(String host,int port) throws IOException
	{
		socket = new MulticastSocket(port);
		System.out.println(socket);
		System.out.println("interface="+socket.getInterface());
		InetAddress	addr = InetAddress.getByName(host);
		socket.joinGroup(addr);
    }
	
	public void	run()
	{
		try
		{
			for (;;)
			{
				socket.setSoTimeout(60*1000);
				byte[]	data = new byte[512];
				DatagramPacket	packet = new DatagramPacket(data,data.length);
				System.out.println("receiver: recv:");
				socket.receive(packet);
				System.out.println("receiver: recv "+packet+":"+packet.getLength()+" from "+packet.getAddress()+":"+packet.getPort());
				// echo the packet
				socket.send(packet);
			}
		}
		catch (IOException exc)
		{
			exc.printStackTrace();
		}
		finally
		{
			socket.close();
			System.out.println("exiting");
		}
	}

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws IOException
	{
		String host = args.length > 0 ? args[0] : "224.0.1.24";
		int	port = args.length > 1 ? Integer.parseInt(args[1]) : 8888;
		new Thread(new MulticastReceiver(host,port)).start();
    }
}
