/*
 * MulticastSender.java
 *
 * Created on 19 June 2002, 15:38
 */

package javanet.mcast;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class MulticastSender
{
	MulticastSocket	socket;

	/** Creates new MulticastSender */
    public MulticastSender(String host, int port) throws IOException
	{
		try
		{
			socket = new MulticastSocket();
			System.out.println(socket);
			System.out.println("interface="+socket.getInterface());
			byte[]	data = "Hullo multicast".getBytes();
			InetAddress	addr = InetAddress.getByName(host);
			DatagramPacket	packet = new DatagramPacket(data,data.length,addr,port);
			socket.send(packet);
			System.out.println("sender: sent "+packet+":"+packet.getLength());
			socket.setSoTimeout(60*1000);
			socket.receive(packet);
			System.out.println("sender: recv: "+packet+":"+packet.getLength()+" from "+packet.getAddress()+":"+packet.getPort()
					+"="+new String(packet.getData(),packet.getOffset(),packet.getLength()));
		}
		finally
		{
			socket.close();
		}
    }

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws IOException
	{
		String host = args.length > 0 ? args[0] : "224.0.1.24";
		int	port = args.length > 1 ? Integer.parseInt(args[1]) : 8888;
		new MulticastSender(host,port);
		System.out.println("exiting");
    }

}
