/*
 * NIOSocketServer.java
 *
 * Created on 14 December 2001, 14:09
 */

package javanet.nio;

import java.io.*;
import java.net.*;
import java.nio.*;
import java.nio.channels.*;
import java.nio.charset.*;
import java.util.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class NIOSocketServer extends java.lang.Object implements java.lang.Runnable {

	private ServerSocketChannel	serverChannel;
	Selector	selector;
	
	/** Creates new NIOSocketServer */
    public NIOSocketServer(int port) throws IOException {
		this.serverChannel = ServerSocketChannel.open();
		this.selector = Selector.open();
		serverChannel.socket().setReceiveBufferSize(8192);
		serverChannel.socket().bind(new InetSocketAddress((InetAddress)null,port));
    }

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws IOException {
		int	port = args.length > 0 ? Integer.parseInt(args[0]) : 1100;
		new NIOSocketServer(port).run();
    }

	/**
	 * When an object implementing interface <code>Runnable</code> is used 
	 * to create a thread, starting the thread causes the object's 
	 * <code>run</code> method to be called in that separately executing 
	 * thread. 
	 * <p>
	 * The general contract of the method <code>run</code> is that it may 
	 * take any action whatsoever.
	 *
	 * @see     java.lang.Thread#run()
 */
	public void run()
	{
		try
		{
			int	ops = serverChannel.validOps();
			System.out.println("Server channel valid ops=0x"+Integer.toHexString(ops));
			// causes IllegalArgumentException
//			ops |= SelectionKey.OP_READ|SelectionKey.OP_WRITE;
			serverChannel.configureBlocking(false);
			SelectionKey acceptKey = serverChannel.register(selector,ops);
			for (;;)
			{
				System.out.println(new Date()+" selecting");
				int	keysAdded = 0;
				while ((keysAdded = selector.select(5000)) > 0)
				{
					System.out.println(new Date()+" select returned "+keysAdded);
					Set	readyKeys = selector.selectedKeys();
					Iterator	it = readyKeys.iterator();
					while (it.hasNext())
					{
						SelectionKey	key = (SelectionKey)it.next();
						it.remove();
						if (!key.isValid())
							continue;
						System.out.print("selected key "+key+"; ready ops=0x"+Integer.toHexString(key.readyOps()));
						if (key.isAcceptable())
							System.out.print("; acceptable");
						if (key.isReadable())
							System.out.print("; readable");
						if (key.isWritable())
							System.out.print("; writable");
						System.out.println("");
						if (key.isAcceptable())
							handleAcceptable(key);
						if (key.isReadable())
							handleReadable(key);
						if (key.isWritable())
							handleWritable(key);
					}
				}
			}
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}

	void	handleAcceptable(SelectionKey key) throws IOException
	{
		ServerSocketChannel	nextReady = (ServerSocketChannel)key.channel();
		SocketChannel	channel = nextReady.accept();
//		channel.socket().setSendBufferSize(8192);
//		channel.socket().setReceiveBufferSize(8192);
//		System.out.println("send buf="+channel.socket().getSendBufferSize());
//		System.out.println("recv buf="+channel.socket().getReceiveBufferSize());
		channel.configureBlocking(false);
		System.out.println(new Date()+" accepted channel "+channel);
		ByteBuffer	buffer = ByteBuffer.allocate(8192);
		channel.register(selector, SelectionKey.OP_READ, buffer);
	}
	
	void	handleReadable(SelectionKey key) throws IOException
	{
		SocketChannel	channel = (SocketChannel)key.channel();
		ByteBuffer	buffer = (ByteBuffer)key.attachment();
		buffer.flip();
		int count = channel.read(buffer);
		System.out.println("read "+count+" bytes into "+buffer);
		if (count < 0)
		{
			key.interestOps(key.interestOps() &~ SelectionKey.OP_READ);
			channel.socket().shutdownInput();
		}
		// Assume writability
		handleWritable();
	}

	void	handleWritable(SelectionKey key) throws IOException
	{
		SocketChannel	channel = (SocketChannel)key.channel();
		ByteBuffer	buffer = (ByteBuffer)key.attachment();
		if (buffer.position() > 0)
		{
			buffer.flip();
			int	count = channel.write(buffer);
			System.out.println("wrote "+count+" bytes from "+buffer);
			buffer.compact();
			if (buffer.hasRemaining())
				// short write - register for writability
				key.interestOps(key.interestOps() | SelectionKey.OP_WRITE);
			else
				// write OK - deregister
				key.interestOps(key.interestOps() & ~SelectionKey.OP_WRITE);
		}
		else
		if ((key.interestOps() & SelectionKey.OP_READ) == 0)
		{
			key.cancel();
			System.out.println(new Date()+": OP_READ not selected for "+channel.socket());
			System.out.println(new Date()+": closing "+channel.socket());
			channel.close();
		}
		/*
		else
		if (channel.socket().isInputShutdown())
		{
			key.cancel();
			System.out.println(new Date()+": isInputShutdown "+channel.socket());
			System.out.println(new Date()+": closing "+channel.socket());
			channel.close();
		}
		*/
		// ...
//		channel.close();
	}
	
}
