/*
 * SSLSupportedCipherSuites.java
 *
 * Created on 19 March 2002, 16:06
 */

package javanet.ssl;

import java.io.*;
import java.net.*;
import javax.net.*;
import javax.net.ssl.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class SSLSupportedCipherSuites implements Runnable, HandshakeCompletedListener {
	SSLServerSocket	serverSocket;
	
	/** Creates new SSLSupportedCipherSuites */
    public SSLSupportedCipherSuites(String host, int port) throws Exception {
		this.serverSocket = (SSLServerSocket)SSLServerSocketFactory.getDefault().createServerSocket(port);
		Thread	t = new Thread(this);
		t.setDaemon(true);
		t.start();
		port = serverSocket.getLocalPort();
		SSLSocket	socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(host,port);
		socket.setEnabledCipherSuites(socket.getSupportedCipherSuites());
		socket.addHandshakeCompletedListener(this);
		socket.getOutputStream().write(new byte[1024]);
/*
 String[]	protocols = socket.getSupportedProtocols();
		for (int i = 0; i < protocols.length; i++)
			System.out.println(protocols[i]);
*/
		String[]	suites = socket.getSupportedCipherSuites();
		for (int i = 0; i < suites.length; i++)
			System.out.println(suites[i]);
		System.out.print("Press <ENTER> to close client socket ...");
		System.in.read();
		socket.close();
		serverSocket.close();
    }

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws Exception {
		String	host = "esmond.rmiproxy.com";
		System.setProperty("javax.net.ssl.keyStore",new File("d:/jsse1.0.2/samples/sockets/server","testkeys").toString());
		System.setProperty("javax.net.ssl.keyStorePassword","passphrase");
		new SSLSupportedCipherSuites(host,0);
    }

	/**
	 * When an object implementing interface <code>Runnable</code> is used 
	 * to create a thread, starting the thread causes the object's 
	 * <code>run</code> method to be called in that separately executing 
	 * thread. 
	 * <p>
	 * The general contract of the method <code>run</code> is that it may 
	 * take any action whatsoever.
	 *
	 * @see     java.lang.Thread#run()
 	*/
	public void run()
	{
		try
		{
//			serverSocket.setEnabledCipherSuites(serverSocket.getSupportedCipherSuites());
			Socket	s = serverSocket.accept();
			byte[]	buffer = new byte[8192];
			int	count = s.getInputStream().read(buffer);
			s.getOutputStream().write(buffer,0,count);
			s.close();
		}
		catch (IOException exc)
		{
			exc.printStackTrace();
		}
		finally
		{
			try
			{
				serverSocket.close();
			}
			catch (IOException exc)
			{
				exc.printStackTrace();
			}
		}
	}
	
	public void handshakeCompleted(javax.net.ssl.HandshakeCompletedEvent p1)
	{
		System.out.println("client handshake complete: "+p1);
	}
	
}
