/*
 * SSLTest.java
 *
 * Created on 9 April 2002, 12:26
 */

package javanet.ssl;

import java.io.*;
import java.net.*;
import java.security.*;
import java.security.cert.*;
import java.util.*;
import javax.net.*;
import javax.net.ssl.*;

// pre JDK1.4 need JSSE imports
//import com.sun.net.ssl.*;

import javanet.tests.WrappedSocket;

/**
 *
 * @author Esmond Pitt
 * @version 
 */
public class SSLTest implements Runnable
{
	static final boolean	doIO = true;
	int    port = 0;
	SSLContext	context;
    SSLServerSocket		ss;
	
	static	// initialization
	{
		System.setProperty("javax.net.ssl.keyStore","testkeys");
//		System.setProperty("javax.net.ssl.keyStore",keysFile.toString());
		System.setProperty("javax.net.ssl.keyStorePassword","passphrase");
		System.setProperty
			(
			"javax.net.debug",
			""
//			+"all"
//			+"ssl"
//			+":handshake"
//			+":keygen"
//			+":keymanager"
//			+":keystore"
//			+":trustmanager"
//			+",session"
//			+",defaultctx"
//			+",sslctx"
//			+",record"
//			+",sessioncache"
			);
	}

	class ConnectionThread extends Thread
	{
		SSLSocket	s;
		
		ConnectionThread(SSLSocket s) throws IOException
		{
			this.s = s;
			super.setDaemon(true);
			s.setSoTimeout(30*1000);
			System.out.println(this+": "+s+" constructed");
		}
		
		public void run()
		{
			System.out.println(this+": "+s+" running");
			try
			{
				trace("server accepted",s);
				byte[]	buffer = new byte[8192];
				int	count;
				InputStream	in = new BufferedInputStream(s.getInputStream());
				OutputStream	out = new BufferedOutputStream(s.getOutputStream(),8192);
//				s.shutdownInput();
				trace ("server reading ",s);
				while ((count = in.read(buffer)) > 0)
				{
					System.out.println(new Date()+": "+"server socket read '"+new String(buffer,0,count)+"'");
					out.write(buffer,0,count);
					out.flush();
					System.out.println("server "+s+"available()="+in.available());
				}
			}
			catch (Exception exc)
			{
				exc.printStackTrace();
			}
			finally
			{
				try
				{
					trace ("server closing ",s);
					s.close();
				}
				catch (IOException exc)
				{
					exc.printStackTrace();
				}
			}
		}
	}

    /** Creates new SSLTest */
    public SSLTest(SSLContext context,int testCount) throws Exception
	{
		this.context = context;
		this.ss = (SSLServerSocket)getServerSocketFactory("TLS").createServerSocket(0);
		this.port = ss.getLocalPort();
//		ss.setWantClientAuth(true);
//		ss.setNeedClientAuth(true);
		String[]	cipherSuites = ss.getEnabledCipherSuites();
		System.out.println(new Date()+": "+cipherSuites.length+" cipher suites:");
		for (int i = 0; i < cipherSuites.length; i++)
			System.out.println(new Date()+": "+"\t"+cipherSuites[i]);

 		// JDK 1.4
		String[]	protocols = ss.getEnabledProtocols();
		System.out.println(protocols.length+" protocols:");
		for (int i = 0; i < protocols.length; i++)
			System.out.println("\t"+protocols[i]);

		Thread	t = new Thread(this);
		t.setDaemon(true);
		t.start();
		test(testCount);
	}
	
	void	test(int testCount) throws IOException
	{
		Socket[]	sockets = new Socket[testCount];
        for (int i = 0; i < sockets.length; i++)
        {
			String	legend = "client-"+i;
			System.out.println(new Date()+": "+legend+": starting.");
            SSLSocket	sock;
			System.out.println("connecting");
			Socket	ws = new /*Wrapped*/Socket("localhost",port);
			System.out.println("connected raw "+ws);
			sock = (SSLSocket)context.getSocketFactory().createSocket(ws, "localhost", port, true);
			trace("converted raw to SSL "+ws,sock);
            sockets[i] = sock;
            SSLSocket   s = (SSLSocket)sockets[i];
			trace("connected ",s);
			Listener	listener = new Listener(legend);
//			s.addHandshakeCompletedListener(listener);
			if (doIO)
			{
				for (int j = 1; j <= 16; j++)
				{
					DataOutputStream	dos = new DataOutputStream
										(
										new BufferedOutputStream
										(
										s.getOutputStream(),8192
										)
										);
					dos.writeBytes(
						legend
						+": "
//						+s.getSession().getProtocol()
						+" ("+j+")");
					dos.flush();
					byte[]	buffer = new byte[8192];
					InputStream	in = new BufferedInputStream(sockets[i].getInputStream());
					int	count = in.read(buffer);
					System.out.println(new Date()+": "+legend+": socket read '"+new String(buffer,0,count)+"'");
//					if (j > 1)
//						break;
					if ((i % 7) == 0)
					{
						System.out.println(new Date()+": "+legend+": disabling session creation for "+s);
						s.setEnableSessionCreation(false);
					}
					else
					if ((i  % 5) == 0)
					{
						System.out.println(new Date()+": "+legend+": invalidating session for "+s);
						s.getSession().invalidate();
					}
					else
					if (((i+j) % 4) == 0)
					{
						System.out.println(new Date()+": "+legend+": startHandshake for "+s);
						s.startHandshake();
//						System.out.println(new Date()+": "+legend+": startHandshake for "+s+" returned");
					}
//					dos.write(new byte[16384]);
				}
//				System.out.println(new Date()+": "+legend+": shutdownOutput.");
//				s.shutdownOutput();
			}
			System.out.println(new Date()+": "+legend+": done.");
//			s.removeHandshakeCompletedListener(listener);
		}
		System.out.print("Press ENTER to close ...");
		System.in.read();
		for (int i = 0; i < sockets.length; i++)
		{
			System.out.println(new Date()+": "+"closing "+sockets[i]);
            sockets[i].close();
			System.out.println(new Date()+": "+"closed "+sockets[i]);
        }
    }

	public void run()
	{
		try
		{
			trace("listening on port "+ss.getLocalPort(),ss);
			Listener	listener = new Listener("server");
			for (;;)
			{
				trace("accepting on",ss);
				SSLSocket	s = (SSLSocket)ss.accept();
				System.out.println("accepted "+s);
				trace("accepted",s);
				s.addHandshakeCompletedListener(listener);
				trace("addedHandshakeCompletedListener to ",s);
				new ConnectionThread(s).start();
			}
		}
		catch (IOException exc)
		{
			exc.printStackTrace();
		}
		finally
		{
			try
			{
				ss.close();
			}
			catch (IOException exc)
			{
				exc.printStackTrace();
			}
		}
	}

	class Listener implements HandshakeCompletedListener
	{
		String	prefix;
		
		Listener(String prefix)
		{
			this.prefix = prefix;
		}

		public synchronized void handshakeCompleted(javax.net.ssl.HandshakeCompletedEvent event)
		{
//			System.out.println(event);
			trace(new Date()+": "+prefix+" handshake",event.getSocket());
//			event.getSession().getSessionContext().setSessionCacheSize(1);
			try
			{
				// JSSE
				javax.security.cert.X509Certificate[] certs = event.getPeerCertificateChain();
//				System.out.println("cert[0]: "+certs[0]);
				// JDK 1.4
/*
 				java.security.cert.Certificate[]	certs = event.getPeerCertificates();
				for (int i = 0; i < certs.length; i++)
				{
					X509Certificate	x509c = (X509Certificate)certs[i];
					System.out.println("\tcert "+i+" subject="+x509c.getSubjectDN()+" issuer="+x509c.getIssuerDN());
				}
*/
			}
			catch (SSLPeerUnverifiedException exc)
			{
				SSLSocket	s = event.getSocket();
				// NO certificates is OK if we are the server and we didn't require them.
				if (!s.getUseClientMode() && !s.getNeedClientAuth())
				{
					System.out.println("\tpeer unverified");
				}
				else
				{
					exc.printStackTrace();
				}
			}
		}
	}
	
    private ServerSocketFactory getServerSocketFactory(String type)
		throws	IOException
	{
		if (type.equals("TLS")) 
		{
			try
			{
				SSLServerSocketFactory ssf = context.getServerSocketFactory();
//				SSLServerSocketFactory ssf = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
				return ssf;
			}
			catch (Exception exc)
			{
				exc.printStackTrace();
			}
			return null;
		}
		else
		{
			return ServerSocketFactory.getDefault();
		}
    }

	synchronized void trace(String legend, SSLServerSocket s)
	{
		System.out.println(
			legend
			+": "
			+s
			);
	}
	
	synchronized void trace(String legend, SSLSocket s)
	{
		System.out.println("tracing "+s);
		SSLSession	session = null;
//		session = s.getSession();
//		System.out.println("tracing "+s+" session="+session);
		SSLSessionContext	context = null;
//		context = session.getSessionContext();
//		System.out.println("tracing "+s+" sessionContext="+context);
		System.out.println(
			legend
			+": "
			+s
			+" session="+session
//			+" protocol="+session.getProtocol()
			+" context="+context
			);
		if (session != null)
		{
			String[]	names = session.getValueNames();
			System.out.println("\t"+names.length+" bindings");
			for (int i = 0; i < names.length; i++)
				System.out.println("\tbinding "+names[i]+"="+session.getValue(names[i]));
		}
		int	count = 0;
		if (context != null)
		{
			Enumeration	en = context.getIds();
			while (en.hasMoreElements())
			{
				byte[] id = (byte[])en.nextElement();
//				System.out.println("\tsession["+(count)+"]="+context.getSession(id));
//				count++;
			}
			System.out.println("\t"+count+" sessions in session context.");
		}
		else
			System.out.println("\tno session context.");
	}

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws Exception
	{
		int	testCount = args.length > 0 ? Integer.parseInt(args[0]) : 100;

		System.out.println(new Date()+": "+"Starting");

		// set up key manager to do server authentication
		SSLContext context = SSLContext.getInstance("TLS");
		KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
		KeyStore ks = KeyStore.getInstance("JKS");
		String	keyStore = System.getProperty("javax.net.ssl.keyStore");
		String	passphrase = System.getProperty("javax.net.ssl.keyStorePassword");
		ks.load(new FileInputStream(keyStore), passphrase.toCharArray());
		kmf.init(ks, passphrase.toCharArray());
		context.init(kmf.getKeyManagers(), null, null);
		System.out.println(new Date()+": SSLContext initialized");
		
		// run the test
        new SSLTest(context,testCount);
		System.out.println(new Date()+": "+"Exiting.");
    }
}
