/*
 * ObjectStreamDeadlock.java
 *
 * Created on 3 March 2003, 11:17
 */

package javanet.tcp;

import java.io.*;
import java.net.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class ObjectStreamDeadlock
{
	public static final int	Port = 2000;
	
	class Server implements Runnable
	{
		ServerSocket	server;
		int	connections = 0;
		
		Server() throws IOException
		{
			this.server = new ServerSocket(Port);
		}
		
		public void	run()
		{
			try
			{
				for (;;)
				{
					new Thread(new DeadlockingConnection(server.accept())).start();
					if (++connections >= 2)
					{
						System.out.println(this+": closing");
						server.close();
						return;
					}
				}
			}
			catch (IOException exc)
			{
				exc.printStackTrace();
			}
		}
	}
	
	class ValidConnection implements Runnable
	{
		Socket	socket;
		
		ValidConnection(Socket socket)
		{
			this.socket = socket;
			System.out.println("new "+this);
		}
		
		public void	run()
		{
			try
			{
				ObjectOutputStream	oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
				oos.flush();
				ObjectInputStream	ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
				System.out.println(this+"no deadlock");
				Object	o = ois.readObject();
				oos.writeObject(o);
				oos.flush();
				oos.close();
				ois.close();
			}
			catch (Exception exc)
			{
				exc.printStackTrace();
			}
		}
	}
	
	class DeadlockingConnection implements Runnable
	{
		Socket	socket;
		
		DeadlockingConnection(Socket socket)
		{
			this.socket = socket;
			System.out.println("new "+this);
		}
		
		public void	run()
		{
			try
			{
				System.out.println(this+": entering possible deadlock");
				ObjectInputStream	ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
				ObjectOutputStream	oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
				oos.flush();
				System.out.println(this+": out of deadlock");
				Object	o = ois.readObject();
				oos.writeObject(o);
				oos.flush();
				oos.close();
				ois.close();
			}
			catch (Exception exc)
			{
				exc.printStackTrace();
			}
		}
	}
	
	class ValidClient implements Runnable
	{
		Socket	socket;
		
		ValidClient(Socket socket)		{ this.socket = socket;	}
		
		public void	run()
		{
			try
			{
				System.out.println(this+": entering possible deadlock");
				ObjectOutputStream	oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
				oos.flush();
				ObjectInputStream	ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
				System.out.println(this+": out of deadlock");
				oos.writeObject("Hello world");
				oos.flush();
				Object	o = ois.readObject();
				System.out.println(this+": "+o);
				oos.close();
				ois.close();
			}
			catch (Exception exc)
			{
				exc.printStackTrace();
			}
		}
	}
	
	class DeadlockingClient implements Runnable
	{
		Socket	socket;
		
		DeadlockingClient(Socket socket)		{ this.socket = socket;	}
		
		public void	run()
		{
			try
			{
				System.out.println(this+": entering possible deadlock");
				ObjectInputStream	ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
				ObjectOutputStream	oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
				oos.flush();
				System.out.println(this+": out of deadlock");
				oos.writeObject("Hello world");
				oos.flush();
				Object	o = ois.readObject();
				System.out.println(this+": "+o);
				oos.close();
				ois.close();
			}
			catch (Exception exc)
			{
				exc.printStackTrace();
			}
		}
	}
			

	/** Creates new ObjectStreamDeadlock */
    public ObjectStreamDeadlock() throws IOException
	{
		new Thread(new Server()).start();
		new Thread(new ValidClient(new Socket("localhost",Port))).start();
		new Thread(new DeadlockingClient(new Socket("localhost",Port))).start();
    }

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws IOException
	{
		new ObjectStreamDeadlock();
    }

}
