package javanet.tcp;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 * VeryConcurrentTCPServer demonstrates how to use a fixed pre-allocated thread pool
 * to improve the efficiency in connections per second of a TCP server.
 *
 * @author Esmond Pitt
 * @version $Revision: 2 $
 */
public class VeryConcurrentTCPServer extends ConcurrentTCPServer
{
	// class data
	static PreallocatedConnectionHandler[]	threadPool;
	
	VeryConcurrentTCPServer(int threads) throws IOException
	{
		super();
		this.threadPool = new PreallocatedConnectionHandler[threads];
		System.out.println("Preallocating "+threads+" threads");
		for (int i = 0; i < threads; i++)
		{
			threadPool[i] = new PreallocatedConnectionHandler();
			threadPool[i].start();
		}
	}
	
	public static void	main(String[] args) throws Exception
	{
		int	threads = args.length > 0 ? Integer.parseInt(args[0]) : 0;
		VeryConcurrentTCPServer	s = new VeryConcurrentTCPServer(threads);
		new Thread(s).start();
		System.out.print("press <Enter> to terminate ... ");
		String	reply = new DataInputStream(System.in).readLine();
		s.server.close();
		for (int i = 0; i < threads; i++)
			threadPool[i].join();
		report(s.connections);
	}
	
	/**
	 * PreallocatedConnectionHandler is the class for pre-allocated threads.
	 *
	 * @author Esmond Pitt
	 * @version $Revision: 2 $
	 */
	class PreallocatedConnectionHandler extends ConnectionHandler
	{
		int	connections = 0;

		PreallocatedConnectionHandler()
		{
			super(null);
			System.out.println(this+" starting");
		}
	
		public void	run()
		{
			for (;;)
			{
				try
				{
					Socket	s = server.accept();
					connections++;
					handleConnection(s);
				}
				catch (SocketException e)
				{
					if (e.getMessage().equalsIgnoreCase("Socket closed"))
						break;
					e.printStackTrace();
				}
				catch (IOException e)
				{
					e.printStackTrace();
				}
			}
			System.out.println(this+" handled "+connections+"/"+VeryConcurrentTCPServer.this.connections+" connections");
		}
	}
}
