package javanet.udp;

import java.io.*;
import java.net.*;
import java.text.*;
import java.util.*;
	
public class ReliableDatagramSocketClient implements Runnable
{
	static final int	Iterations	= 1000;
	int	iterations = Iterations;
	ReliableDatagramSocket	socket;
	InetAddress	dest;
	int	tries		= 0;
	int	failures	= 0;
	int	port;

	ReliableDatagramSocketClient(InetAddress dest,int port, int iterations)
		throws IOException
	{
		super();
		this.socket = new ReliableDatagramSocket();
		this.dest = dest;
		this.port = port;
		this.iterations = iterations;
		socket.setSendBufferSize(32*1024);
		socket.setReceiveBufferSize(32*1024);
//		System.out.println(new Date()+": "+getClass().getName()+" constructed");
	}
	
	public void	close()
	{
		socket.close();
	}

	public void	run()
	{
		byte[]	sendData = new byte[512];
		byte[]	recvData	= new byte[512];
		for (int i = 0; i < iterations; i++)
		{
			tries++;
			try
			{
				DatagramPacket	sendPacket = new DatagramPacket(sendData,sendData.length,dest,port);
				DatagramPacket	recvPacket = new DatagramPacket(recvData,recvData.length);
//				System.out.println(getClass().getName()+" send/recv # "+i+"/"+socket.getSendSequenceNo());
				socket.sendReceive(sendPacket,recvPacket);
//				socket.send(sendPacket);	// for testing
			}
			catch (InterruptedIOException e)
			{
				System.out.println(getClass().getName()+": "+e);
				failures++;
//				e.printStackTrace();
			}
			catch (IOException e)
			{
				System.out.println(getClass().getName()+": "+e);
//				e.printStackTrace();
			}
		}
		System.out.println(getClass().getName()+" exiting: success rate="+(((tries-failures)*100)/tries)+"%");
	}
	
	public static void	main(String[] args)
	{
		final int	Port	= 1111;
		try
		{
			InetAddress	host = (args.length > 0) ? InetAddress.getByName(args[0]) : InetAddress.getLocalHost();
			int	port = (args.length > 1) ? Integer.parseInt(args[1]) : Port;
			int	minDiscardRate = (args.length > 2) ? Integer.parseInt(args[2]) : 2;
			int	maxDiscardRate = (args.length > 3) ? Integer.parseInt(args[3]) : 9;
			int	duplicateRate = (args.length > 4) ? Integer.parseInt(args[4]) : 5;
			int iterations = (args.length > 5) ? Integer.parseInt(args[5]) : Iterations;
			long[]	time = new long[32];
			ReliableDatagramSocket.RoundTripTimer[]	rtt = new ReliableDatagramSocket.RoundTripTimer[maxDiscardRate+1];
			for (int discardRate = minDiscardRate; discardRate <= maxDiscardRate; discardRate++)
			{
				long	start = System.currentTimeMillis();
				UnreliableServer	server = null;
				if (host.equals(InetAddress.getLocalHost()))
				{
					server = new UnreliableServer(port,discardRate,duplicateRate);
					server.start();
				}
				ReliableDatagramSocketClient	client = new ReliableDatagramSocketClient(host,port,iterations);
				client.run();
				if (server != null)
					server.close();
				client.close();
				long	stop = System.currentTimeMillis();
				time[discardRate] = stop-start;
				rtt[discardRate] = client.socket.roundTripTimer;
				System.gc();
				System.runFinalization();
				for (int i = minDiscardRate; i <= discardRate; i++)
				{
					MessageFormat	format = new MessageFormat
						(
						"error rate {0,number,#0}% elapsed {1,number,#####0.###}s "+rtt[i]
						);
					Object[]	msgArgs =
					{
						new Integer(i),
						new Float(time[i]),
					};
					System.out.println(format.format(msgArgs));
				}
			}
		}
		catch (Throwable t)
		{
			t.printStackTrace();
		}
		finally
		{
			System.gc();
			System.runFinalization();
			System.runFinalizersOnExit(true);
			System.out.println("main() exiting");
		}
	}
}
