/*
 * UDPEchoClient.java
 *
 * Created on 29 November 2001, 10:43
 */

package javanet.udp;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class UDPEchoClient extends java.lang.Thread {

	private DatagramSocket socket;
	
	private byte[] reply = new byte[1024*12];
	
	/** Creates new UDPEchoClient */
    public UDPEchoClient() throws IOException {
		socket = new DatagramSocket();
		System.out.println("default recv bufsize="+socket.getReceiveBufferSize());
		System.out.println("default send bufsize="+socket.getSendBufferSize());
		socket.setReceiveBufferSize(reply.length*3);
		socket.setSendBufferSize(reply.length*3);
		System.out.println("recv bufsize="+socket.getReceiveBufferSize());
		System.out.println("send bufsize="+socket.getSendBufferSize());
		System.out.println("local addr="+socket.getLocalAddress()+":"+socket.getLocalPort());
    }

	/**
	 * When an object implementing interface <code>Runnable</code> is used 
	 * to create a thread, starting the thread causes the object's 
	 * <code>run</code> method to be called in that separately executing 
	 * thread. 
	 * <p>
	 * The general contract of the method <code>run</code> is that it may 
	 * take any action whatsoever.
	 *
	 * @see     java.lang.Thread#run()
	 */
	public void run() {
		try
		{
			InetAddress	address = InetAddress.getByName("leonora.rmiproxy.com");
			byte[]	request;
			ByteArrayOutputStream	baos = new ByteArrayOutputStream();
			DataOutputStream	dos = new DataOutputStream(baos);
			dos.writeInt(0x12345678);
			dos.writeUTF("hello UDP world!");
			dos.flush();
//			request = new byte[1024*48];
			System.out.println("length="+baos.toByteArray().length+" offset="+4+" size="+baos.size());
			DatagramPacket	packet = new DatagramPacket(baos.toByteArray(),4,baos.size()-4,address,1099);
			socket.send(packet);
			System.out.println(new Date()+": sent "+packet.getLength()+" bytes to "+packet.getAddress()+":"+packet.getPort());
			packet.setData(reply,50,reply.length-50);
			socket.setSoTimeout(30*1000);
			socket.receive(packet);
			System.out.println(new Date()+": recv "+packet.getLength()+" bytes from "+packet.getAddress()+":"+packet.getPort());
			ByteArrayInputStream	bais = new ByteArrayInputStream(packet.getData(),packet.getOffset(),packet.getLength());
			DataInputStream	dis = new DataInputStream(bais);
			String	str = dis.readUTF();
			System.out.println("string="+str+" available="+dis.available());
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws IOException {
		UDPEchoClient	client = new UDPEchoClient();
		client.run();
    }
	
}
