/*
 * AcceptingQueueProcessor.java
 *
 * Created on 5 February 2002, 15:18
 */

package javanet.arch;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class AcceptingQueueProcessorTest extends java.lang.Object {

	/** Creates new AcceptingQueueProcessor */
    public AcceptingQueueProcessorTest() {
    }

    /**
    * @param args the command line arguments
    */
	public static void	main(String[] args) throws IOException {
		ServerSocket	server = new ServerSocket(1100);
		Queue			queue = new SocketAcceptingQueue(server);
		for (int i = 0; i < 16; i++)
			new Thread(new QueueProcessor(queue), "QueueProcessor-"+i).start();
		System.err.println(new Date()+": driver running");
		for (int i = 0; i < 32; i++)
			new Client("localhost",1100).run();
		queue.terminate();
		server.close();
		System.err.println(new Date()+": driver exiting: activeCount="+Thread.currentThread().getThreadGroup().activeCount());
	}
	
	static class Client implements Runnable {
		String	host;
		int	port;
		
		Client(String host, int port)
		{
			this.host = host;
			this.port = port;
		}
		
		public void	run() {
			synchronized (QueueProcessor.class) {
				System.err.println(new Date()+": "+Thread.currentThread()+": running");
			}
			try {
				Socket	socket = new Socket(host, port);
				socket.close();
			}
			catch (IOException exc) {
				synchronized (QueueProcessor.class) {
					System.err.println(new Date()+": "+Thread.currentThread());
					exc.printStackTrace(System.err);
				}
			}
			System.out.println(new Date()+": "+Thread.currentThread()+": exiting");
		}
	}
}
