/*
 * DynamicAcceptingQueueProcessorTest.java
 *
 * Created on 5 February 2002, 17:23
 */

package javanet.arch;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class DynamicAcceptingQueueProcessorTest extends java.lang.Thread {
	ServerSocket	server;
	Queue			queue;
	
	/** Creates new DynamicAcceptingQueueProcessorTest */
    public DynamicAcceptingQueueProcessorTest(ServerSocket server) throws IOException {
		this.server = server;
		this.queue = new SocketAcceptingQueue(server);
    }
	
	public void	run() {
		System.err.println(new Date()+": driver running");
		for (int i = 0; i < 8; i++)
			new Thread(new DynamicQueueProcessor(null,queue), "DynamicQueueProcessor-"+i).start();
		int	dynamicThreadCount = 0;
		for (;;) {
			try {
				if (queue.waitCount() > 0)
					Thread.currentThread().sleep(500);
				else {
					Socket	connection = (Socket)queue.dequeue(1000);
					if (connection == null)
						break;
					new Thread(new DynamicQueueProcessor(connection,queue)).start();
					dynamicThreadCount++;
				}
			} catch (InterruptedException exc) {
			}
		}
		queue.terminate();
		System.err.println(
			new Date()+": driver exiting"
			+": activeCount="+Thread.currentThread().getThreadGroup().activeCount()
			+"; dynamic threads="+dynamicThreadCount
			);
	}

    /**
    * @param args the command line arguments
    */
	public static void	main(String[] args) throws IOException {
		ServerSocket	server = new ServerSocket(1100);
		new DynamicAcceptingQueueProcessorTest(server).start();
		for (int i = 0; i < 32; i++)
			new Client("localhost",1100).run();
		server.close();
	}
	
	static class Client implements Runnable {
		String	host;
		int	port;
		
		Client(String host, int port)
		{
			this.host = host;
			this.port = port;
		}
		
		public void	run() {
			synchronized (DynamicQueueProcessor.class) {
				System.err.println(new Date()+": "+Thread.currentThread()+": running");
			}
			try {
				Socket	socket = new Socket(host, port);
				byte[]	buffer = new byte[8192];
				socket.getOutputStream().write(buffer);
				int	count = socket.getInputStream().read(buffer);
				socket.close();
			}
			catch (IOException exc) {
				synchronized (DynamicQueueProcessor.class) {
					System.err.println(new Date()+": "+Thread.currentThread());
					exc.printStackTrace(System.err);
				}
			}
			System.out.println(new Date()+": "+Thread.currentThread()+": exiting");
		}
	}
}
