/*
 * DynamicQueueProcessor.java
 *
 * Created on 5 February 2002, 15:40
 */

package javanet.arch;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class DynamicQueueProcessor extends java.lang.Object implements javanet.arch.ConnectionProcessor {

	private java.net.Socket connection;
	
	private Queue queue;
	
	/** Creates new DynamicQueueProcessor */
    public DynamicQueueProcessor(Socket connection, Queue queue) {
		this.connection = connection;
		this.queue = queue;
    }

	/**
	 * When an object implementing interface <code>Runnable</code> is used 
	 * to create a thread, starting the thread causes the object's 
	 * <code>run</code> method to be called in that separately executing 
	 * thread. 
	 * <p>
	 * The general contract of the method <code>run</code> is that it may 
	 * take any action whatsoever.
	 *
	 * @see     java.lang.Thread#run()
 */
	public void run()
	{
		synchronized (this.getClass()) {
			System.err.println(new Date()+": "+Thread.currentThread()+" running");
		}
		do {
			if (connection != null)
				process(connection);
			connection = (Socket)queue.dequeue();
		} while (connection != null);
		synchronized (this.getClass()) {
			System.err.println(new Date()+": "+Thread.currentThread()+" exiting");
		}
	}
	
	public void process(java.net.Socket connection)
	{
		synchronized (this.getClass()) {
			System.err.println(new Date()+": "+Thread.currentThread() +" processing connection");
		}
		try {
			byte[]	buffer = new byte[8192];
			for (;;) {
				int	count = connection.getInputStream().read(buffer);
				if (count < 0)
					break;
				connection.getOutputStream().write(buffer,0,count);
			}
			connection.close();
		} catch (IOException exc) {
			synchronized (this.getClass()) {
				System.err.println(new Date()+": "+Thread.currentThread());
				exc.printStackTrace(System.err);
			}
		}
	}
}
