/*
 * MultiHomedBroadcast.java
 *
 * Created on 14 June 2002, 12:33
 */

package javanet.mcast;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 * @author  ejp
 * @version $Revision: 1 $
 */
public class MultiHomedBroadcast
{

	/** Creates new MultiHomedBroadcast */
    public MultiHomedBroadcast() throws IOException
	{
		byte[]	data = new byte[512];
		DatagramSocket	socket = new DatagramSocket();
		DatagramPacket	packet = new DatagramPacket(data,data.length,null,8888);
		Enumeration		intfs = NetworkInterface.getNetworkInterfaces();
		while (intfs.hasMoreElements())
		{
			NetworkInterface	intf = (NetworkInterface)intfs.nextElement();
			System.out.println("interface "+intf);
			Enumeration			addrs = intf.getInetAddresses();
			while (addrs.hasMoreElements())
			{
				InetAddress	ina = (InetAddress)addrs.nextElement();
				byte[]		addr = ina.getAddress();
				if (addr[0] == 127)
					continue;
				// assume class D subnet
				int		netmask = 0xffffff00;
				// form subnet broadcast address
				int bca = netmask ^ 0xffffffff;
				for (int i = 3; i >= 0; i--)
					addr[i] |= (byte)(bca >>> (3-i)*8);
				InetAddress	bcAddr = InetAddress.getByAddress(addr);
				System.out.println("\tbroadcasting to "+bcAddr);
				packet.setAddress(bcAddr);
				// assuming data, length, & port are already set in packet
				socket.send(packet);
			}
		}
	}

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws IOException
	{
		new MultiHomedBroadcast();
    }

}
