/*
 * NIOSocketClient.java
 *
 * Created on 13 December 2001, 16:39
 */

package javanet.nio;

import java.io.*;
import java.net.*;
import java.nio.*;
import java.nio.channels.*;
import java.nio.charset.*;
import java.util.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class NIOSocketClient extends java.lang.Object implements java.lang.Runnable {
	SocketChannel	channel;
	Charset	cs = Charset.forName("ISO-8859-1");
	byte[]	bytes = new byte[81920];
	ByteBuffer	request = ByteBuffer.allocate(bytes.length);
	ByteBuffer	reply = ByteBuffer.allocate(bytes.length);

	/** Creates new NIOSocketClient */
    public NIOSocketClient(String host, int port) throws IOException {
		this.channel = SocketChannel.open();
		channel.socket().setSendBufferSize(8192);
		channel.socket().setReceiveBufferSize(8192);
		System.out.println("send buf="+channel.socket().getSendBufferSize());
		System.out.println("recv buf="+channel.socket().getReceiveBufferSize());
		channel.configureBlocking(false);
		channel.connect(new InetSocketAddress(host,port));
		System.out.println
		(
			"isConnectionPending="+channel.isConnectionPending()
			+" isOutputShutdown="+channel.socket().isOutputShutdown()
			+" isInputShutdown="+channel.socket().isInputShutdown()
		);
    }

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws IOException {
		String	host = args.length > 0 ? args[0] : "localhost";
		int		port = args.length > 1 ? Integer.parseInt(args[1]) : 1111;
		new NIOSocketClient(host,port).run();
    }

	/**
	 * When an object implementing interface <code>Runnable</code> is used 
	 * to create a thread, starting the thread causes the object's 
	 * <code>run</code> method to be called in that separately executing 
	 * thread. 
	 * <p>
	 * The general contract of the method <code>run</code> is that it may 
	 * take any action whatsoever.
	 *
	 * @see     java.lang.Thread#run()
	 */
	public void run()
	{
		try
		{
			request.put(bytes);
			Selector	sel = Selector.open();
			channel.register(sel, channel.validOps());
			while (sel.keys().size() > 0)
			{
				int	nsel = sel.select(5000);
				System.out.println("select returned "+nsel);
				Iterator	it = sel.selectedKeys().iterator();
				while (it.hasNext())
				{
					SelectionKey	key = (SelectionKey)it.next();
					it.remove();
					System.out.print("key ops=0x"+Integer.toHexString(key.readyOps()));
					if (key.isConnectable()) System.out.print("; isConnectable");
					if (key.isReadable()) System.out.print("; isReadable");
					if (key.isWritable()) System.out.print("; isWritable");
					System.out.println("");
					if (key.isValid() && key.isConnectable())
						handleConnectable(key);
					if (key.isValid() && key.isReadable())
						handleReadable(key);
					if (key.isValid() && key.isWritable())
						handleWritable(key);
				}
			}
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}
	
	void	handleConnectable(SelectionKey key) throws IOException
	{
		SocketChannel	channel = (SocketChannel)key.channel();
		boolean	ok = channel.finishConnect();
		System.out.println("finishConnect="+ok);
	}

	void	handleReadable(SelectionKey key) throws IOException
	{
		CharBuffer	cb = reply.asCharBuffer();
		SocketChannel	channel = (SocketChannel)key.channel();
		int	count = channel.read(reply);
		System.out.println("Read count="+count+": '"+reply+"'");
		if (count < 0)
		{
			key.cancel();
			channel.close();
			return;
		}
		reply.flip();
		System.out.println("Flipped "+reply);
		cb = cs.decode(reply);
		System.out.println(new Date()+": received '"+cb.toString()+"':"+count);
		reply.flip();
	}

	void	handleWritable(SelectionKey key) throws IOException
	{
		SocketChannel	channel = (SocketChannel)key.channel();
		if (channel.socket().isClosed())
			return;
		CharBuffer	cb = request.asCharBuffer();
//		cb.put("Hello from NIO");
//		System.out.println("Flipping pos="+cb.position()+" lim="+cb.limit()+" '"+cb+"'");
//		cb.flip();
//		System.out.println("Flipped pos="+cb.position()+" lim="+cb.limit()+" '"+cb+"'");
//		buffer = cs.encode(cb);
		request.flip();
		int	count = channel.write(request);
		System.out.println("wrote "+count+" bytes; remaining="+request.remaining());
		if (!request.hasRemaining())
		{
			channel.socket().shutdownOutput();
			key.interestOps(key.interestOps() & ~SelectionKey.OP_WRITE);
		}
		request.compact();
	}
}
