package javanet.nio;

import java.io.*;
import java.net.*;
import java.nio.*;
import java.nio.channels.*;
import java.util.*;

public class NewIO_UDP_EchoServer implements Runnable
{
	static final int	TIMEOUT = 5000;								// 5s
	private 		ByteBuffer	buffer = ByteBuffer.allocate(8192);
	private DatagramChannel	channel;
	private List	outputQueue = new LinkedList();
	// Create new NewIO_UDP_EchoServer
	public NewIO_UDP_EchoServer(int port) throws IOException
	{
		this.channel = DatagramChannel.open();
		SocketAddress	addr = new InetSocketAddress(port);
		channel.socket().bind(addr);
		channel.configureBlocking(false);
	}
	// Runnable. run method
	public void run()
	{
		try
		{
			Selector	selector = Selector.open();
			channel.register(selector, SelectionKey.OP_READ);
			// loop while there are any registered channels
			while (!selector.keys().isEmpty())
			{
				int	keysAdded = selector.select(TIMEOUT);
				// Standard post-select processing 
				Set	selectedKeys = selector.selectedKeys();
				synchronized (selectedKeys)
				{
					Iterator	it = selectedKeys.iterator();
					while (it.hasNext())
					{
						SelectionKey	key = (SelectionKey)it.next();
						it.remove();
						if (!key.isValid())
							continue;
						if (key.isReadable())
							handleReadable(key);
						if (key.isWritable())
							handleWritable(key);
					} // while
				} // synchronized
			} // while
		} // try
		catch (IOException e)
		{
			// 
		}
	} // run()

	// handle readable key
	void	handleReadable(SelectionKey key)
	{
		DatagramChannel channel = (DatagramChannel)key.channel();
		try
		{
			buffer.clear();
			SocketAddress	address = channel.receive(buffer);
			if (address == null)
				return;								// no data
			buffer.flip();
			channel.send(buffer, address);
			int	count = buffer.remaining();
			if (count > 0)
			{
				// Write failure: queue the write request
				// as a DatagramPacket, as this nicely holds
				// the data and reply address
				byte[]	bytes = new byte[count];
				buffer.get(bytes);
				outputQueue.add(new DatagramPacket(bytes, count, address));
				// Register for OP_WRITE
				key.interestOps(SelectionKey.OP_READ|SelectionKey.OP_WRITE);
			}
		}
		catch (IOException e)
		{
			// 
		}
	} // handleReadable()

	// handle writable key
	void	handleWritable(SelectionKey key)
	{
		DatagramChannel channel = (DatagramChannel)key.channel();
		try
		{
			while (!outputQueue.isEmpty())
			{
				DatagramPacket	packet = (DatagramPacket)outputQueue.get(0);
				buffer.clear();
				buffer.put(packet.getData());
				buffer.flip();
				channel.send(buffer, packet.getSocketAddress());
				if (buffer.hasRemaining())
					// write failed, try later
					return;
				outputQueue.remove(0);
			}
			// All writes succeeded:
			// deregister for OP_WRITE
			key.interestOps(SelectionKey.OP_READ);
		}
		catch (IOException e)
		{
			// 
		}
	} // handleWritable()
}	// end of NIOUDPEchoServer