/*
 * SessionManagedSSLClient.java
 *
 * Created on 28 May 2002, 15:09
 */

package javanet.ssl;

import java.io.*;
import java.net.*;
import java.security.*;
import java.security.cert.*;
// import com.sun.net.ssl.*;	// pre JDK 1.4
import javax.net.ssl.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class SessionManagedSSLClient implements HandshakeCompletedListener
{
	private SSLContext			sslContext;
	private SSLSocketFactory	socketFactory;
	private SSLSessionContext	clientSessionContext;
	private SSLSocket socket;
	
	static	// initializer
	{
//		System.setProperty("javax.net.debug","ssl:handshake:trustmanager");
	}
	
	/** Creates new SessionManagedSSLClient */
    public SessionManagedSSLClient(String host,int port)
		throws IOException, GeneralSecurityException
	{
		if (sslContext == null)
		{
			this.sslContext = SSLContext.getInstance("TLS");
			sslContext.init(null,null,null);
			System.out.println("SSLContext="+sslContext);
			// Configure the client session context
			this.clientSessionContext = sslContext.getClientSessionContext();
			System.out.println("clientSessionContext="+clientSessionContext);
			// Cache up to ten sessions
			clientSessionContext.setSessionCacheSize(10);
			// and time them out after 1 hour.
			clientSessionContext.setSessionTimeout(60*60);
			this.socketFactory = sslContext.getSocketFactory();
			System.out.println("socketFactory="+socketFactory);
		}
		this.socket = (SSLSocket)socketFactory.createSocket(host,port);
		System.out.println("socket="+socket);
		socket.addHandshakeCompletedListener(this);
		SSLSession session = socket.getSession();
		System.out.println("session="+session);
		// See if we got the same session context
		SSLSessionContext sc = session.getSessionContext();
		System.out.println("socket.session.sessionContext="+sc);
		System.out.println("same="+(sc != null && sc.equals(this.clientSessionContext)));
		socket.close();
    }

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws Exception
	{
		String	host = args[0];
		int		port = Integer.parseInt(args[1]);
		new SessionManagedSSLClient(host,port);
    }

	public void handshakeCompleted(HandshakeCompletedEvent event)
	{
		System.out.println(event);
		try
		{
//			javax.security.cert.X509Certificate[]	peerCerts = event.getPeerCertificateChain();
			java.security.cert.Certificate[]	peerCerts = event.getPeerCertificates();
			// Verify DN of zeroth certificate ...
			System.out.println("peer DN is "+((X509Certificate)peerCerts[0]).getSubjectDN());
		}
		catch (SSLPeerUnverifiedException exc)
		{
			System.err.println(exc);
		}
	}
}
