/*
 * SessionManagedSSLServer.java
 *
 * Created on 28 May 2002, 15:09
 */

package javanet.ssl;

import java.io.*;
import java.net.*;
import java.security.*;
import java.security.cert.*;
// import com.sun.net.ssl.*;	// pre JDK 1.4
import javax.net.ssl.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class SessionManagedSSLServer implements HandshakeCompletedListener, Runnable
{
	private SSLContext			sslContext;
	private SSLServerSocketFactory	socketFactory;
	private SSLSessionContext	serverSessionContext;
	private SSLServerSocket serverSocket;
	static final File	keysFile = new File("d:/jsse1.0.2/samples/sockets/server","testkeys");
	static final String passphrase = "passphrase";
	
	static	// initialization
	{
		System.setProperty("javax.net.ssl.keyStore",keysFile.toString());
		System.setProperty("javax.net.ssl.keyStorePassword",passphrase);
//		System.setProperty("javax.net.debug","ssl:handshake:trustmanager");
	}
	
	/** Creates new SessionManagedSSLServer */
    public SessionManagedSSLServer(int port)
		throws IOException, GeneralSecurityException
	{
		if (sslContext == null)
		{
			this.sslContext = SSLContext.getInstance("TLS");
			sslContext.init(null,null,null);
			System.out.println("SSLContext="+sslContext);
			// Configure the server session context
			this.serverSessionContext = sslContext.getServerSessionContext();
			System.out.println("serverSessionContext="+serverSessionContext);
			// Cache up to four sessions
			serverSessionContext.setSessionCacheSize(4);
			// and time them out after 15 minutes.
			serverSessionContext.setSessionTimeout(15*60);
			this.socketFactory = sslContext.getServerSocketFactory();
			System.out.println("socketFactory="+socketFactory);
		}
		this.serverSocket = (SSLServerSocket)socketFactory.createServerSocket(port);
		System.out.println("socket="+serverSocket);
    }

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws Exception
	{
		int		port = Integer.parseInt(args[0]);
		new Thread(new SessionManagedSSLServer(port)).start();
    }

	public void handshakeCompleted(HandshakeCompletedEvent event)
	{
		System.out.println(event);
		try
		{
//			javax.security.cert.X509Certificate[]	peerCerts = event.getPeerCertificateChain();
			java.security.cert.Certificate[]	peerCerts = event.getPeerCertificates();
			// Verify DN of zeroth certificate ...
			System.out.println("peer DN is "+((X509Certificate)peerCerts[0]).getSubjectDN());
		}
		catch (SSLPeerUnverifiedException exc)
		{
			System.err.println(exc);
		}
	}
	
	/**
	 * When an object implementing interface <code>Runnable</code> is used
	 * to create a thread, starting the thread causes the object's
	 * <code>run</code> method to be called in that separately executing
	 * thread.
	 * <p>
	 * The general contract of the method <code>run</code> is that it may
	 * take any action whatsoever.
	 *
	 * @see     java.lang.Thread#run()
	 */
	public void run ()
	{
		for (;;)
		{
			try
			{
				SSLSocket	socket = (SSLSocket)serverSocket.accept();
				socket.addHandshakeCompletedListener(this);
				new ConnectionThread(socket).start();
			}
			catch (IOException exc)
			{
				System.err.println(exc);
			}
		}
	}
	
	class ConnectionThread extends Thread
	{
		SSLSocket	socket;
		
		ConnectionThread(SSLSocket socket)
		{
			this.socket = socket;
			SSLSession session = socket.getSession();
			System.out.println("session="+session);
			// See if we got the same session context
			SSLSessionContext sc = session.getSessionContext();
			System.out.println("socket.session.sessionContext="+sc);
			System.out.println("same="+(sc != null && sc.equals(serverSessionContext)));
//			socket.close();
		}
		
		public void	run()
		{
			try
			{
				InputStream		in = new BufferedInputStream(socket.getInputStream());
				OutputStream	out = new BufferedOutputStream(socket.getOutputStream(),8192);
				// ...
			}
			catch (IOException exc)
			{
			}
			finally
			{
				try
				{
					socket.close();
				}
				catch (SSLException exc)
				{
					// possible truncation attack ...
				}
				catch (IOException exc)
				{
				}
			}
		}
	}	
}
