package javanet.tcp;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 * VeryConcurrentTCPServer demonstrates how to use a fixed pre-allocated thread pool
 * to improve the efficiency in connections per second of a TCP server.
 *
 * @author Esmond Pitt
 * @version $Revision: 1 $
 */
public class ConcurrentTCPServer extends TCPServer
{
	// class data
	static final int	Port = 1100;
	
	ConcurrentTCPServer() throws IOException
	{
		super();
	}
	
	public void	run()
	{
		int	connections = 0;
		for (;;)
		{
			try
			{
				Socket	s = server.accept();
				connections++;
				new ConnectionHandler(s).start();
			}
			catch (SocketException e)
			{
				if (e.getMessage().equalsIgnoreCase("Socket closed"))
					break;
				e.printStackTrace();
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}
		System.out.println(Thread.currentThread().getName()+" handled "+connections+"/"+this.connections+" connections");
	}
	
	public static void	main(String[] args) throws Exception
	{
		ConcurrentTCPServer	s = new ConcurrentTCPServer();
		new Thread(s).start();
		System.out.print("press <Enter> to terminate ... ");
		String	reply = new DataInputStream(System.in).readLine();
		s.server.close();
		report(s.connections);
	}
	
	/**
	 * ConnectionHandler is the class for dynamically-allocated threads.
	 *
	 * @author Esmond Pitt
	 * @version $Revision: 1 $
	 */
	class ConnectionHandler extends Thread
	{
		Socket	s;

		ConnectionHandler(Socket s)	{ this.s = s;	}
		
		public void	run()
		{
			handleConnection(s);
		}
	}
}
