/*
 * UDPEchoServer.java
 *
 * Created on 29 November 2001, 10:33
 */

package javanet.udp;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 * @author  ejp
 * @version 
 */
public class UDPEchoServer extends java.lang.Thread {

	private DatagramSocket socket;
	
	private byte[] buffer = new byte[16384];
	
	/** Creates new UDPEchoServer */
    public UDPEchoServer() throws IOException {
		socket = new DatagramSocket(1099);
		System.out.println("default recv bufsize="+socket.getReceiveBufferSize());
		System.out.println("default send bufsize="+socket.getSendBufferSize());
		socket.setReceiveBufferSize(buffer.length*3);
		socket.setSendBufferSize(buffer.length*3);
		System.out.println("recv bufsize="+socket.getReceiveBufferSize());
		System.out.println("send bufsize="+socket.getSendBufferSize());
		System.out.println("local addr="+socket.getLocalAddress()+":"+socket.getLocalPort());
    }
	
	public void	run()
	{
		for (;;)
		{
			try
			{
				DatagramPacket	packet = new DatagramPacket(buffer,50,100);
//				DatagramPacket	packet = new DatagramPacket(buffer,0,buffer.length);
				socket.receive(packet);
				System.out.println(new Date()+": recv "+packet.getLength()+" bytes from "+packet.getAddress()+":"+packet.getPort());
				ByteArrayInputStream	bais = new ByteArrayInputStream(packet.getData(),packet.getOffset(),packet.getLength());
				DataInputStream	dis = new DataInputStream(bais);
				String	str = dis.readUTF();
				System.out.println("string="+str+" available="+dis.available());
				socket.send(packet);
				System.out.println(new Date()+": sent "+packet.getLength()+" bytes to "+packet.getAddress()+":"+packet.getPort());
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}
	}

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws Exception {
		UDPEchoServer	server = new UDPEchoServer();
		server.run();
    }

}
