package javanet.udp;

import java.io.*;
import java.net.*;
import java.util.*;

public class UnreliableServer extends Thread
{
	ReliableDatagramSocket	socket;
	int	discardRate		= 0;	// percentage 0..100
	int	duplicateRate	= 10;	// percentage
	Random	randomizer = new Random();
	byte[]	buffer = new byte[1024];
	DatagramPacket	recvPacket = new DatagramPacket(buffer,buffer.length);
	
	UnreliableServer(int port,int discardRate,int duplicateRate)
		throws IOException
	{
		super();
		this.socket = new ReliableDatagramSocket(port);
		this.discardRate = discardRate;
		this.duplicateRate = duplicateRate;
		super.setDaemon(true);
		System.out.println("UnreliableServer running at "+socket.getLocalAddress()+":"+socket.getLocalPort());
		System.out.println("Discard rate = "+(100.0*discardRate)/100+"% duplicate rate = "+(100.0*duplicateRate)/100+"%");
	}
	
	public void	close()
	{
//		System.out.println(getClass().getName()+": closing");
		socket.close();
		socket = null;
//		System.out.println(getClass().getName()+" closed");
	}
	
	public void	run()
	{
		while (socket != null)
		{
			try
			{
				// Restore the receive length!
				recvPacket.setLength(buffer.length);
				socket.receive(recvPacket);
				if (isInterrupted())
					break;
				long	seqno = socket.getRecvSequenceNo();
				if (randomizer.nextDouble()*100.0 <= discardRate)
				{
//					System.out.println(new Date()+": "+getClass().getName()+": dropping packet # "+i);
					continue;	// ignore the packet
				}
//				System.out.println(getClass().getName()+" got a packet - acknowledging");
				socket.setSendSequenceNo(seqno);
				socket.send(recvPacket);
				// Send it twice?
				// NB only get here (100-discardRate) % of the time.
				if (randomizer.nextDouble()*100.0/discardRate <= duplicateRate)
				{
//					System.out.println(new Date()+": "+getClass().getName()+": retransmitting response # "+i);
					socket.setSendSequenceNo(seqno);
					socket.send(recvPacket);
				}
			}
			catch (IOException e)
			{
				System.err.println(getClass().getName()+":");
				e.printStackTrace();
			}
		}
	}

	public static void	main(String[] args)
	{
		final int	Port = 1111;
		try
		{
			int	discardRate = (args.length > 0)? Integer.parseInt(args[0]) : 3;
			int	duplicateRate = (args.length > 1)? Integer.parseInt(args[1]) : 0;
			new UnreliableServer(Port,discardRate,duplicateRate).start();
			System.out.print("Press any key to exit ...");
			System.in.read();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
