% Copyright Ashish Tewari (c) 2006
function xdot=spaceimpulse(t,x) 
J1=1500; J3=500; 
thd2=acos(J3/(J1-J3));
n=1; 
T=0.01; 
umax=J3*n*tan(thd2)/T; 
Ts=T+pi/abs(n*(1-J3/J1)); 
if t>=0 && t<=T 
    u=umax;
elseif t>Ts && t<=Ts+T
    u=umax;
else
    u=0;
end
xdot(1,1)=x(2)*n*(J1-J3)/J1;
xdot(2,1)=x(1)*n*(J3-J1)/J1+u/J1;
xdot(3,1)=(sin(x(5))*x(2)+cos(x(5))*n)/cos(x(4));
xdot(4,1)=cos(x(5))*x(2)-sin(x(5))*n;
xdot(5,1)=x(1)+(sin(x(5))*x(2)+cos(x(5))*n)*tan(x(4));