; --------------------------------------------------------------------
; --------------------------------------------------------------------
; Regression Analysis
; --------------------------------------------------------------------
; --------------------------------------------------------------------

library("xplore")
library("nummath")
library("graphic")
library("plot")

; --------------------------------------------------------------------
; --------------------------------------------------------------------

data = read("E:\Dokumente und Einstellungen\Anthony\Eigene Dateien\My projects\E-Papers\XCS\Chapter 13\fat.dat")

n = rows(data)
n1 = 165
p = cols(data)-1

data1 = data[1:n1,1:p]
data2 = data[(n1+1):n, 1:p] 
resp1 = data[1:n1, (p+1)]
resp2 = data[(n1+1):n, (p+1)] 

; --------------------------------------------------------------------
; Semi-metric d_{der,2}
; --------------------------------------------------------------------

semi = "der"
q = 2
param =  list( q, 40, #(0,1) )
ris1 = FuncKerRegKnnCV(resp1, data1, data2, param, semi)

; --------------------------------------------------------------------
; Usual L2 semi-metric
; --------------------------------------------------------------------

semi = "der"
q = 0
param =  list( q, 40, #(0,1) )
ris2 = FuncKerRegKnnCV(resp1, data1, data2, param, semi)

; --------------------------------------------------------------------
; graphic for comparison
; --------------------------------------------------------------------

dis = createdisplay(1,2)
show(dis, 1, 1, resp2 ~ ris1.PredictedValues')
show(dis, 1, 2, resp2 ~ ris2.PredictedValues')
setgopt(dis, 1, 1, "title", "(a)", "xlabel", "Observed values", "ylabel", "Predicted values" , "border", 0)
setgopt(dis, 1, 2, "title", "(b)", "xlabel", "Observed values", "ylabel", "Predicted values", "border", 0)

; --------------------------------------------------------------------
; --------------------------------------------------------------------



