; --------------------------------------------------------------------
; --------------------------------------------------------------------
; Missclassification Analisys
; --------------------------------------------------------------------
; --------------------------------------------------------------------

library("xplore")
library("nummath")
library("graphic")
library("plot")

; --------------------------------------------------------------------
; --------------------------------------------------------------------

proc(results) = simula(data, k, test)

; --------------------------------------------------------------------
; k = number of trials
; test = dimension of the training set (as percentage of the numbers
; 				of the rows of the dataset
; --------------------------------------------------------------------

	n = rows(data)
	n1 = round(test*n, 0)
	p = cols(data)-1
	mae = matrix( (k*4) )

	i=1
	while(i <= k)
	per = permutation(n,1)
	datatest = data[ per , ]

	data1 = datatest[1:n1,1:p]
	data2 = datatest[(n1+1):n, 1:p] 
	resp1 = datatest[1:n1, (p+1)]
	resp2 = datatest[(n1+1):n, (p+1)] 

		; simulation with semi-norm = PCA
		semi = "pca"
		param = 40
		ris = FuncKerDiscrim(resp1, data1, data2, param, semi)
		mae[i] = mean( resp2 != ris.PredictedGroups )
		i = i+1
	endo

	while(i <= (k*2))
	per = permutation(n,1)
	datatest = data[ per , ]

	data1 = datatest[1:n1,1:p]
	data2 = datatest[(n1+1):n, 1:p] 
	resp1 = datatest[1:n1, (p+1)]
	resp2 = datatest[(n1+1):n, (p+1)] 

		; simulation with semi-norm = DER0
		semi = "der"
		q = 0
		param =  list( q, 20, #(0,1) )
		ris = FuncKerDiscrim(resp1, data1, data2, param, semi)
		mae[i] = mean( resp2 != ris.PredictedGroups )
		i = i+1
	endo

	while(i <= (k*3))
	per = permutation(n,1)
	datatest = data[ per , ]

	data1 = datatest[1:n1,1:p]
	data2 = datatest[(n1+1):n, 1:p] 
	resp1 = datatest[1:n1, (p+1)]
	resp2 = datatest[(n1+1):n, (p+1)] 

		; simulation with semi-norm = DER1
		semi = "der"
		q = 1
		param =  list( q, 20, #(0,1) )
		ris = FuncKerDiscrim(resp1, data1, data2, param, semi)
		mae[i] = mean( resp2 != ris.PredictedGroups )
		i = i+1
	endo

	while(i <= (k*4))
	per = permutation(n,1)
	datatest = data[ per , ]

	data1 = datatest[1:n1,1:p]
	data2 = datatest[(n1+1):n, 1:p] 
	resp1 = datatest[1:n1, (p+1)]
	resp2 = datatest[(n1+1):n, (p+1)] 

		; simulation with semi-norm = DER2
		semi = "der"
		q = 2
		param =  list( q, 20, #(0,1) )
		ris = FuncKerDiscrim(resp1, data1, data2, param, semi)
		mae[i] = mean( resp2 != ris.PredictedGroups )
		i = i+1
	endo

	results = mae

endp

; --------------------------------------------------------------------
; --------------------------------------------------------------------

data = read("E:\Dokumente und Einstellungen\Anthony\Eigene Dateien\My projects\E-Papers\XCS\Chapter 13\fat.dat")
k = 50
tt = 165/215
maetot = simula(data, k, tt)

; --------------------------------------------------------------------
; --------------------------------------------------------------------

cases = string("PCA", 1:k) | string("L2 - norm", 1:k) | string("1st - Der", 1:k) |string("2nd - Der" , 1:k)
plotbox(maetot, cases)
setgopt(boxplot, 1, 1, "xlabel"," ", "ylabel","Rates of missclassification", "xaxis", 0 , "border", 0)

; --------------------------------------------------------------------
; --------------------------------------------------------------------

