proc(y)=HFestim(X,d,xx,ker,h,nu)

; -----------------------------------------------------------------

; Library       hazker

; -----------------------------------------------------------------

; See_also      HFdensband HFitsteff HFestimci

; -----------------------------------------------------------------

; Macro         HFestim

; -----------------------------------------------------------------

; Description   kernel estimation of derivative of hazard function

; -----------------------------------------------------------------

; Usage        y=HFestim(X,d,xx,ker,h,nu)

;  Input

;    Parameter  X

;    Definition  n x 1 array - lifetimes

;    Parameter  d

;    Definition  n x 1 array - censoring values

;    Parameter  xx

;    Definition  m x 1 array - points for evalueting the hazard function

;    Parameter  ker

;    Definition  string - kernel with support [-1,1]

;    Parameter  h

;    Definition  scalar - bandwidth

;    Parameter  nu

;    Definition  scalar - order of the derivative of the hazard

;                         function to be estimated (default 0)

;

;  Output

;    Parameter  y

;    Definition  m x 1 array - values of the hazard function in xx

; -----------------------------------------------------------------

; Example   library("plot")

;           library("hazker")

;           data1=read("HFdata1.dat")

;           X=data1[,1]

;           d=data1[,2]

;           xx = aseq(0, 120, 2)

;           ker="optker04"

;           h=40

;           y = HFestim(X,d,xx,ker,h)

;           line(xx~y)

; -----------------------------------------------------------------

; Result        The estimation of the hazard function is presented

; -----------------------------------------------------------------

; Keywords      hazard function, kernel,

; -----------------------------------------------------------------

; Reference

; -----------------------------------------------------------------

; Author        Ji Zelinka

; -----------------------------------------------------------------

;





if(exist("nu")!=1)

 nu=0

endif



n=rows(X)

m=rows(xx)



hp=h

j=0

while (j<nu)

 hp=hp*h

 j=j+1

endo



np=1./(n+1-(1:n));

xp=(xx[1]-X)/h

yp=d.*_ker(xp).*np

y=sum(yp)

j=1

while (j<m)

 j=j+1

 xp=(xx[j]-X)/h

 yp=d.*_ker(xp).*np

 y=y~sum(yp)

endo

y=y'/hp

y=y.*(y>0)



endp

