proc(y,ylo,yhi)=HFestimci(X,d,xx,ker,h,nu,alpha)

; -----------------------------------------------------------------

; Library       hazker

; -----------------------------------------------------------------

; See_also      HFdensband HFiterband HFestim

; -----------------------------------------------------------------

; Macro         HFestimci

; -----------------------------------------------------------------

; Description   kernel estimation of derivative of hazard function

;               with confidence intervals

;               Confidence intervals are counted only for 0-th

;               derivative

; -----------------------------------------------------------------

; Usage        {y,ylo,yhi}=HFestimci(X,d,xx,ker,h,nu,alpha)

;  Input

;    Parameter  X

;    Definition  n x 1 array - lifetimes

;    Parameter  d

;    Definition  n x 1 array - censoring values

;    Parameter  xx

;    Definition  m x 1 array - points for evalueting the hazard function

;    Parameter  ker

;    Definition  string - kernel with support [-1,1]

;    Parameter  h

;    Definition  scalar - bandwidth

;    Parameter  nu

;    Definition  scalar - order of the derivative of the hazard

;                         function to be estimated (default 0)

;    Parameter  alpha

;    Definition  scalar - confidence interval level (default 0.05)

;

;  Output

;    Parameter  y

;    Definition  m x 1 array - values of the hazard function in xx

;    Parameter  ylo

;    Definition  m x 1 array - lower bound of the confidence interval

;    Parameter  yhi

;    Definition  m x 1 array - upper bound of the confidence interval

; -----------------------------------------------------------------

; Example   library("plot")

;           library("hazker")

;           data1=read("HFdata1.dat")

;           X=data1[,1]

;           d=data1[,2]

;           xx = aseq(0, 120, 2)

;           ker="optker04"

;           h=40

;           {y,ylo,yhi} = HFestimci(X,d,xx,ker,h)

;           line(xx~ylo,x~y,x~yhi)

; -----------------------------------------------------------------

; Result        The estimation of the hazard function with

;               confidence intervals is presented

; -----------------------------------------------------------------

; Keywords      hazard function, kernel, confidence interval

; -----------------------------------------------------------------

; Reference

; -----------------------------------------------------------------

; Author        Ji Zelinka

; -----------------------------------------------------------------

;



library("distribs")

prec=0.000001



if(exist("nu")!=1)

 nu=0

endif



if(exist("alpha")!=1)

 alpha=0.05

endif



n=rows(X)

m=rows(xx)



hp=h

j=0

while (j<nu)

 hp=hp*h

 j=j+1

endo



np=1./(n+1-(1:n));

xp=(xx[1]-X)/h

yp=d.*_ker(xp).*np

y=sum(yp)

j=1

while (j<m)

 j=j+1

 xp=(xx[j]-X)/h

 yp=d.*_ker(xp).*np

 y=y~sum(yp)

endo

y=y'/hp

y=y.*(y>0)



; computation od confidence intervals



if (nu==0)

; comutation of integral V(K)

 err=1

 a=-1

 b=1

 step=1

 ni=1

 I0=_ker(a).*_ker(a)+_ker(b).*_ker(b)

 xi=0

 I1=(_ker(xi).*_ker(xi)+0.5*(_ker(a)+_ker(b)))*step

 II1=(4*I1-I0)/3

 while (err>prec)

  I0=I1

  II0=II1

  step=step/2

  ni=ni*2

  xi=aseq(a+step,ni,2*step)

  Ip=step*sum((_ker(xi).*_ker(xi)))

  I1=0.5*I0+Ip

  II1=(4*I1-I0)/3

  err=abs((II1-II0)/II1)

 endo

 V=II1



; computation of L_n

 L=sum(X<=xx[1])

 j=1

 while(j<m)

  j=j+1

  Lp=sum(X<=xx[j])

  L=L~Lp

 endo

 L=L'/(n+1);



 differ=sqrt((V/(n*h^(2*nu+1)))*(y./(1-L)))*qfn2(1-alpha/2)

 yhi=y+differ;

 ylo=y-differ;

 ylo=ylo.*(ylo>0)



endif



endp

