proc(hnew)=HFib1step(hold,X,d,ker,k)

; -----------------------------------------------------------------

; Library       hazker

; -----------------------------------------------------------------

; See_also      HFiterband, HFestim

; -----------------------------------------------------------------

; Macro         HFib1step

; -----------------------------------------------------------------

; Description   one step of iterative method in estimation

;               of optimal bandwidth for hazard function estimate

; -----------------------------------------------------------------

; Usage        hnew = HFib1step(hold,X,d,ker,k)

;  Input

;    Parameter  hold

;    Definition  scalar - previous iteration of optimal bandwidth

;    Parameter  X

;    Definition  n x 1 array - sample of random variable

;    Parameter  d

;    Definition  n x 1 array - censoring values

;    Parameter  ker

;    Definition  string - kernel with support [-1,1]

;    Parameter  k

;    Definition  scalar - order of the kernel

;

;  Output

;    Parameter  hnew

;    Definition  scalar - new iteration of optimal bandwidth

; -----------------------------------------------------------------

; Example

; -----------------------------------------------------------------

; Result

; -----------------------------------------------------------------

; Keywords      hazard function, kernel, bandwidth

; -----------------------------------------------------------------

; Reference

; -----------------------------------------------------------------

; Author        Ji Zelinka

; -----------------------------------------------------------------

;



;library("")



n=rows(X)



minX=min(X)

maxX=max(X)

a=0

b=maxX+2*hold

; interval for integration in x direction



nx=100

stepx=(b-a)/nx

xx=aseq(a,nx+1,stepx)

ny=100

stepy=2/ny

yy=aseq(-1,ny+1,stepy)

pxN=matrix(nx+1,1)

pxD=matrix(nx+1,1)

i=0

while(i<nx+1) ; composite trapezoidal rule in x direction

 i=i+1

 x=xx[i]

 py=x-hold*yy

 pyD=HFestim(X,d,py,ker,hold).*_ker(yy)

 L=1-sum(X<=py')/(n+1)

 pyN=pyD.*_ker(yy)./L'

 IyN=(sum(pyN[2:ny])+0.5*(pyN[1]+pyN[ny+1]))*stepy

 IyD=(sum(pyD[2:ny])+0.5*(pyD[1]+pyD[ny+1]))*stepy

 pxN[i]=IyN

 pxD[i]=(IyD-HFestim(X,d,x,ker,hold))^2

endo

IN=(sum(pxN[2:nx])+0.5*(pxN[1]+pxN[nx+1]))*stepx

ID=(sum(pxD[2:nx])+0.5*(pxD[1]+pxD[nx+1]))*stepx



hnew=IN/(ID*2*n*k)



endp

