proc(h)=HFiterband(X,d,ker,k)

; -----------------------------------------------------------------

; Library       hazker

; -----------------------------------------------------------------

; See_also      HFestim densiterband HFb1step

; -----------------------------------------------------------------

; Macro         HFiterband

; -----------------------------------------------------------------

; Description   estimation of optimal bandwidth for hazard function

;               estimate using iterative Steffensen method

; -----------------------------------------------------------------

; Usage        h = HFiterband(X,d,ker,k)

;  Input

;    Parameter  X

;    Definition  n x 1 array - sample of random variable

;    Parameter  d

;    Definition  n x 1 array - censoring values

;    Parameter  ker

;    Definition  string - kernel with support [-1,1]

;    Parameter  k

;    Definition  scalar - order of the kernel

;

;  Output

;    Parameter  h

;    Definition  scalar - estimation of the optimal bandwidth

; -----------------------------------------------------------------

; Example   library("plot")

;           library("hazker")

;           data1=read("HFdata1.dat")

;           X=data1[,1]

;           d=data1[,2]

;           ker="optker02"

;           k = 2

;           h = HFiterband(X,d,ker,k)

;           x = aseq(-3,0.02,301)

;           y = HFestim(X,d,x,ker,h)

;           line(x~y)

; -----------------------------------------------------------------

; Result        The estimation of the optimal bandwidth

;               is counted and the estimate of hazard

;               function is presented

; -----------------------------------------------------------------

; Keywords      hazard function, kernel, bandwidth

; -----------------------------------------------------------------

; Reference

; -----------------------------------------------------------------

; Author        Ji Zelinka

; -----------------------------------------------------------------

;



;library("")

prec=0.001

maxit=50

n=rows(X)

; initial value

hold=densiterband(X,ker,k)

;b=#(2.5324, 3.3175, 3.9003, 4.3949, 4.8349, 5.2361)

; constants for upper band of bandwidth

;sig=sqrt(var(X))

;hold=(sig*b[k/2]*n^(-1/(2*k+1)))/2



h1=HFib1step(hold,X,d,ker,k)

h2=HFib1step(h1,X,d,ker,k)

hnew=hold-(h1-hold)^2/(h2-2*h1+hold)

errh=abs((hnew-hold)/hnew)

ni=1

while((errh>prec) && (ni<maxit))

 hold=hnew

 h1=HFib1step(hold,X,d,ker,k)

 h2=HFib1step(h1,X,d,ker,k)

 hnew=hold-(h1-hold)^2/(h2-2*h1+hold)

 errh=abs((hnew-hold)/hnew)

 ni=ni+1

endo



h=hnew

endp

