proc()=ITTnicemat(title,onetree,prec)
; ---------------------------------------------------------------------
; Library     finance
; ---------------------------------------------------------------------
; See_also    ITT, grITTcrr, IBTnicemat
; ---------------------------------------------------------------------
; Macro       ITTnicemat
; ---------------------------------------------------------------------
; Description writes any matrix with the ITT convention style as a string
;             where the central node is in the middle
; ---------------------------------------------------------------------
; Usage       ITTnicemat(title,onetree,prec)
; Input       
; Parameter   title
; Definition  string; description of onetree
; Parameter   onetree
; Definition  matrix; correspond to any output matrix of ITT(.): 
;             Ttree, P, Q, AD or LocVol.
; Parameter   prec
; Definition  scalar; the precision of the description
; Output      
; ---------------------------------------------------------------------
; Example     
;    library("finance")
;
;    proc(sigma)=volafunc(S,K,time)	
;        sigma=0.15 + (K-S)/10 * 0.005 
;    endp
;
;    S = 100	        ; current index level
;    r = 0.1		; interest rate
;    div = 0.05         ; dividend yield
;    time = 0|0.5|1	; 2 half-year periods
;
;    t=ITT(S, r, div, time, "volafunc")
;    t.Ttree
;    ITTnicemat("State space of the ITT",t.Ttree,2)
; ---------------------------------------------------------------------
; Result 
;    Contents of Ttree
;    [1,]      100   116.18   134.99 
;    [2,]     +NAN      100   116.18 
;    [3,]     +NAN   86.071      100 
;    [4,]     +NAN     +NAN   86.071 
;    [5,]     +NAN     +NAN   74.082 
;
;    State space of the ITT
;                     134.99
;             116.18  116.18
;     100.00  100.00  100.00
;              86.07   86.07
;                      74.08
; ---------------------------------------------------------------------
; Keywords    implied volatilities, Black Scholes model, option pricing
; ---------------------------------------------------------------------
; Reference   E. Derman, I. Kani and N. Chriss (1996): 
;             Implied Trinomial Trees of the Volatility Smile <br>
;             K. Komorad (2002): Implied Trinomial Trees and Their Implementation with XploRe
; ---------------------------------------------------------------------
; Link        www.gs.com/qs
; ---------------------------------------------------------------------
; Author      K. Komorad 20020401
; ---------------------------------------------------------------------
;
    k  = rows(onetree)
    l  = cols(onetree)
    kl = k*l
    error(k!=2*l-1,"onetree has wrong dimensions")
    error(l<2,"onetree must have at least 2 columns")
    error(dim(prec)!=1,"prec must be scalar")
    error((prec<0)||(floor(prec)!=prec),"prec must be a non-negative integer")
;
    wid = strlen(string("%.0f", max(max(onetree,2))))+prec+2
    format1 = string("%%%.0f.%.0ff", wid, prec)	; format of a number
    format0 = string("%%%.0fs", wid)		; format if there is no number
; resort
    res = string(format1,onetree[,l])
    nan = NaN
    m=1
    while(m<l)	; make the differences from the back in the tree
        res = string(format1,(nan|onetree[1:k-m,l-m])) ~ res
        nan = NaN|nan
        m=m+1
    endo
; output    
  old1 = getenv("outputstringformat")
  old2 = getenv("outlineno")
  old3 = getenv("outheadline")
  setenv("outheadline","\n"+"\n"+title+"\n")
  setenv("outputstringformat", "%s")
  setenv("outlineno", "")
  replace(res, string(format1, NaN), string(format0, ""))
  setenv("outputstringformat", old1)
  setenv("outlineno", old2)
  setenv("outheadline", old3)
endp

