proc(fx)=ITTterm(t)
; ---------------------------------------------------------------------
; Library     finance
; ---------------------------------------------------------------------
; See_also    ITT, nmnewton
; ---------------------------------------------------------------------
; Macro       ITTterm
; ---------------------------------------------------------------------
; Description An auxiliary macro for ITT. It computes value of the 
;             non-linear equation system in given points. 
; ---------------------------------------------------------------------
; Usage       fx=ITTterm(t)
; Input       
; Parameter   t
; Definition  vector, time points
; Output      
; Parameter   fx
; Definition  vector, values of the equation systen in t
; ---------------------------------------------------------------------
; Notes       This macro is used for determining the scaled time points
;             when there is a significant term structure. Called by 
;             nmnewton(.)
; ---------------------------------------------------------------------
; Author      K. Komorad 20020324
; ---------------------------------------------------------------------
  T = getglobal("ITTtermparameter")	    ; final time point
  termvola = getglobal("ITTtermstructure")  ; volatility function defined by the user
  st = _termvola(t)
  sT = _termvola(T)
  error(dim(st)!=dim(t),"your term volatility function returns data with wrong dimension")
  s  = sum(1/st^2) + 1/sT^2
  cs = cumsum(1/st^2)
  fx = t.*s - T.*cs                         ; we are searching t so that fx==0
endp

