proc(jac)=ITTtermder(t)
; ---------------------------------------------------------------------
; Library     finance
; ---------------------------------------------------------------------
; See_also    ITT, nmnewton
; ---------------------------------------------------------------------
; Macro       ITTtermder
; ---------------------------------------------------------------------
; Description An auxiliary macro for ITT. It computes values of the 
;             Jacobian of the non-linear equation system in given points. 
; ---------------------------------------------------------------------
; Usage       jac=ITTtermder(t)
; Input       
; Parameter   t
; Definition  vector; time points
; Output      
; Parameter   jac
; Definition  matrix; Jacobian matrix
; ---------------------------------------------------------------------
; Notes       This macro is used for determining the scaled time points
;             when there is a significant term structure. Called by 
;             nmnewton(.)
; ---------------------------------------------------------------------
; Author      K. Komorad 20020324
; ---------------------------------------------------------------------
  T = getglobal("ITTtermparameter")         ; final time point
  termvola  = getglobal("ITTtermstructure") ; volatility function defined by the user
  dtermvola = getglobal("ITTtermderivative"); 1st derivative of the vola function - from the user
  st  = _termvola(t)
  dst = _dtermvola(t)
  sT  = _termvola(T)
  error(dim(st)!=dim(t),"your term volatility function returns data with wrong dimension")
  error(dim(dst)!=dim(t),"your derivative function returns data with wrong dimension")  
; compute the upper triangular matrix  
  ut = matrix(rows(t)) * (1:rows(t))'
  ut = (ut + sort(ut',-1))>rows(t)
;
  div = 2 * dst ./ (st^3)
  s  = (sum(1/st^2) + 1/sT^2) * matrix(rows(t))
  jac = -t*div' + diag(s) - T.*ut.*div
endp

