library("plot")
library("smoother")
library("metrics")
randomize(200)
library("stats")

;###########################################################################
;############################subroutine for calculate reference curve########
;###########################################################################


;###########################################################################
;###### kernel estimation for F(y|x)######
;###########################################################################
;######XX initial sample (expalanatory variable)
;######YY (dependent variable)
;######h smoothing parameter
proc(F)=foncrepartcond(y,x,xx,yy,h)
num=(pdfn((x-xx)/h))'*(yy<=y)
denom=sum(pdfn((x-xx)/h))
F=num/denom
endp

;###########################################################################





;###########################################################################
;#####subroutine for choosing  h by cross-validation (Yao (1999))
;##### compute cv for one h 
;###########################################################################
proc(r)=CV(x,xx,yy,h,n)
r=0
i=1
j=1
	do
	do
	ind=yy[i]<=yy[j]
	if (i==1)
	xxx=xx[2:n]
	yyy=yy[2:n]
	else 
	if (i==n)
	xxx=xx[1:n-1]
	yyy=yy[1:n-1]
	else
	xxx=vec(xx[1:i-1],xx[i+1:n])
	yyy=vec(xx[1:i-1],yy[i+1:n])
	endif
	endif
	vc=foncrepartcond(yy[j],x,xxx,yyy,h)
	r=r+(ind-vc)*(ind-vc)
	j=j+1	
	until(j>n)
	j=1
  i=i+1
  until(i>n)
endp
;###########################################################################







;#############procedure for ploting (cv(h),h)#############################
;gcvopt value of h which minimize cv
;gcv value of cv(gcvopt)
;###########################################################################
proc(gcvopt,gcv)=graphcv(hpoints,x,xx,yy,Ncv,n)
i=1
;gcv=zeros(Ncv)
gcv=matrix(Ncv,2)
gcvord=matrix(Ncv,2)

do 
hpoints[i]
gcv[i,1]=CV(x,xx,yy,hpoints[i],n)
gcv[i]
gcv[i,2]=i
i=i+1
until(i>Ncv)

gcvord=sort(gcv,1)
gcvopt=hpoints[gcvord[1,2]]
gracv=hpoints~gcv
gracv=setmask(gracv,"line","red")

d=createdisplay(1,1)
show(d, 1, 1, gracv)
setgopt(d,1,1,"title","CV","xlabel","h","ylabel","cv")
endp
;############################################################






;############################################################
;########### subroutine rtbis ###############################
;############################################################
; rtbis gives the value of y such as  F(y|x)-alpha=0
;xacc 
;alpha quantile order
;for one x 
;h smoothing parameter
;xx and  yy initial sample data

proc(s,convergence)=rtbis(y1,y2,xacc,alpha,x,xx,yy,h) 
xmind=0											
jmax=100
fmid=foncrepartcond(y2,x,xx,yy,h)-alpha
f=foncrepartcond(y1,x,xx,yy,h)-alpha
if(f*fmid>=0) ; warning fmid*f should be negative
s=9999
else
if(f<=0)
s=y1
dx=y2-y1 
else
s=y2
dx=y1-y2
endif
j=0
do
dx=dx*0.5
xmid=s+dx
fmid=foncrepartcond(xmid,x,xx,yy,h)-alpha
if(fmid<=0)
 s=xmid
endif
if(abs(dx)<xacc||fmid==0)
j=jmax+1
convergence="OK"
else 
j=j+1
convergence="nOK"
endif
until(j>jmax)
endif
endp


;######################################################
;procedure for reference curve
;######################################################

proc(yalphamin,yalphamax)=courberef(xpoints,xx,yy,n,NNx,choixcv,h)
yalphamin=zeros(NNx)
yalphamax=zeros(NNx)
Ncv=9 ; number of h for the grid [hmin,hmax] if choicv="ok"
;hmin=(max(xx)-min(xx))/size(xx)
hmin=0.1 
hmax=1
;hmax=(max(xx)-min(xx))
hpoints = hmin + (hmax-hmin)/(Ncv-1) .* (0:Ncv-1)  ;
i=1
do
if(choixcv=="ok")
hcvopt=graphcv(hpoints,xpoints[i],xx,yy,Ncv,n) ; h choosing by cv
hopt=hcvopt.gcvopt
else
hopt=h    ; same h for all xpoints
endif
;hcvopt
a=rtbis(min(yy),max(yy),0.001,0.05,xpoints[i],xx,yy,hopt)
b=rtbis(min(yy),max(yy),0.001,0.95,xpoints[i],xx,yy,hopt)
yalphamin[i]=a.s
yalphamax[i]=b.s
i=i+1
until(i>NNx)
endp


;######################################################
;######################################################
;######################################################
;######################################################



n=300; sample size
p=10; number of explanatory variable
btrue=#(1,1,1,1,1,-1,-1,-1,-1,0)
btrue=(1/3)*btrue

;xx=read("C:\WINDOWS\Bureau\Jerome-Recherche\e-book\RefCurves\FichiersPrVieu\SARGGL_X.txt",n,p)
;yy=read("C:\WINDOWS\Bureau\Jerome-Recherche\e-book\RefCurves\FichiersPrVieu\SARGGL_Y.txt",n,1)

xx=read("E:\Dokumente und Einstellungen\Anthony\Eigene Dateien\My projects\E-Papers\LaTeX\localhost compilation\SARGGL_X.txt",n,p)
yy=read("E:\Dokumente und Einstellungen\Anthony\Eigene Dateien\My projects\E-Papers\LaTeX\localhost compilation\SARGGL_Y.txt",n,1)

b = sir(xx, yy, -20)
beta=b.edr ; direction e.d.r beta
eigen=b.eigen ; valeur propre
eigen
write(eigen[1:10],"eigen_values.txt")
write(beta[,1],"EDR.txt")
edr=beta[,1]
edr
;calculate cos^2(beta[,1],btrue)
coscare=(beta[,1]'*btrue)^2/((beta[,1]'*beta[,1])*(btrue'*btrue))
write(coscare,"coscarre.txt")
coscare


;we only keep one estimated EDR direction beta[1,]
;the reduced data xcl=xx*(beta[1,])
xcl=xx*(beta[,1])

;#############################################
;figure for  ebook
;#############################################

;G1 : Scree plot of eigenvalues 
figure0  = createdisplay(1,1)
g1=1:size(eigen)~eigen
g1=setmask(g1,"red")
show(figure0,1,1,g1)
setgopt(figure0,1,1,"title","Scree plot of eigenvalues ","xlabel"," ","ylabel","Eigen values ", "border", 0)
print(figure0,"eigen_sim.ps")


;####################################################
;####################figure for true indice##########
;####################figure 1.1######################

NNN=1000
zmin=min(xx*btrue)
zmax=max(xx*btrue)
xpoints = zmin + (zmax-zmin)/(NNN-1) .* (0:NNN-1)  ;

graph1=xx*btrue~yy
graph1= setmask(graph1,"star","black")

alphamin=0.05
alphamax=0.95

;the true 90% reference curves 
qalphamin=1+exp(2*(sort(xx*btrue))/3)-1.646
qalphamax=1+exp(2*(sort(xx*btrue))/3)+1.646

;the estimated reference curves
graph2=sort(xx*btrue)~qalphamin
graph2= setmask(graph2,"line","red","dotted")

graph3=sort(xx*btrue)~qalphamax
graph3=setmask(graph3,"line","red","dotted")

NNx=50
xpoints = zmin + (zmax-zmin)/(NNx-1) .* (0:NNx-1)
trueindex=courberef(xpoints,xx*btrue,yy,n,NNx,"no",0.3)

graph4=xpoints~trueindex.yalphamin
graph4= setmask(graph4,"line","blue","dashed")

graph5=xpoints~trueindex.yalphamax
graph5=setmask(graph5,"line","blue","dashed")


graph4l = regxest(graph4,1)                
graph4l = setmask(graph4l, "line","blue")


graph5l = regxest(graph5,1)                
graph5l = setmask(graph5l, "line","blue")


figure1=createdisplay(1,1)
axeson() 

show(figure1, 1, 1, graph1,graph2,graph3,graph4,graph5,graph4l,graph5l)
setgopt(figure1,1,1,"title"," ","xlabel","True index","ylabel","Y", "border", 0)
print(figure1,"figure1.ps")

;######################################################################
;     figure 1.2  estimated index
;######################################################################

zmin=min(xcl)
zmax=max(xcl)

graph1=xcl~yy
graph1= setmask(graph1,"star","black")

NNx=50
xpoints = zmin + (zmax-zmin)/(NNx-1) .* (0:NNx-1)
estimatedindex=courberef(xpoints,xcl,yy,n,NNx,"no",0.3)

graph4=xpoints~estimatedindex.yalphamin
graph4= setmask(graph4,"line","blue","dashed")

graph5=xpoints~estimatedindex.yalphamax
graph5=setmask(graph5,"line","blue","dashed")


graph4l = regxest(graph4,1)                
graph4l = setmask(graph4l, "line","blue")


graph5l = regxest(graph5,1)                
graph5l = setmask(graph5l, "line","blue")


figure2=createdisplay(1,1)
axeson() 

show(figure2, 1, 1, graph1,graph4,graph5,graph4l,graph5l)
setgopt(figure2,1,1,"title"," ","xlabel","Estimated index","ylabel","Y", "border",0)
print(figure2,"figure2.ps")






