; --------------------------------------------------------------------
; --------------------------------------------------------------------
; SEMI-METRIC DER_2
; --------------------------------------------------------------------
; --------------------------------------------------------------------
; It requires the quantlet Spline.xpl by Christophe Crambes
; --------------------------------------------------------------------
; --------------------------------------------------------------------

library("xplore")
library("nummath")

; --------------------------------------------------------------------
; --------------------------------------------------------------------

proc(semimetric) = SemiMetricDer2(data1, nknot, rangegrid, data2)

; --------------------------------------------------------------------
; B-spline approximation of the curves containing in DATASET :
; --------------------------------------------------------------------
; "knot" and "x" allow to define the B-spline basis
; nknot = number of interior knots, 
; rangegrid = #(t1,tp) [a vector with the limits of the grid]
; "CoefMat[, i]" corresponds to the B-spline expansion
; of the discretized curve contained in DATASET[i, ]. 
; The B-spline approximation of the curve contained in "data[i, ]" 
; is given by "BasSpline * CoefMat[, i]"
; --------------------------------------------------------------------

	q = 2
	knot = (1:nknot) / (nknot+1)
	p = cols(data1)
	a = rangegrid[1]
	b = rangegrid[2]
  	x = aseq(a, p, 1/(p-1)) * b
	orderBspline = q + 3
	delta = sort( #(a * matrix(orderBspline) ,  b * matrix(orderBspline) , knot ) )
	delta = delta[ (q+3) : (dim(delta)-(q+2)) ]
	BasSpline = bspline(x, delta, orderBspline, 0)
	Cmat = BasSpline' * BasSpline
	Dmat1 = BasSpline' *  data1'
	Solve = nmGJelim(Cmat, Dmat1)
	CoefMat1 = Solve.x

; --------------------------------------------------------------------
; Numerical integration by the Gauss method :
; --------------------------------------------------------------------
; The objects ending by "gauss" allow us to compute numerically  
; integrals by means the "Gauss method" (lxgauss=6 ==> the computation 
; of the integral is exact for polynom of degree less or equal to 11).
; --------------------------------------------------------------------

	pointgauss = #(-0.9324695142, -0.6612093865, -0.2386191861, 0.2386191861, 0.6612093865, 0.9324695142)
	weightgauss = #(0.1713244924, 0.360761573, 0.4679139346, 0.4679139346, 0.360761573, 0.1713244924)
	xgauss = 0.5 * (b-a) * (1 + pointgauss)
	lxgauss = dim(xgauss)
	BsplineDeriv = bspline(xgauss, delta, orderBspline, q)
	H = BsplineDeriv' * (BsplineDeriv .* (weightgauss .* 0.5*(b-a)))
	eigH = eigensm(H)
	eigHval = eigH.values
	eigHvect = eigH.vectors
	eigFlag = 1 - (eigHval < 0)
	eigHval = eigHval .* eigFlag
	Hhalf = (eigHvect * (eigHvect' .* sqrt(eigHval)))'
	COEF1 = (Hhalf * CoefMat1)'

	Dmat2 = BasSpline' * data2'
	Solve2 = nmGJelim(Cmat, Dmat2)
	CoefMat2 = Solve2.x
	COEF2 = (Hhalf * CoefMat2)'

	n1 = rows(data1)
	n2 = rows(data2)
	semimetric = 0
	nbasis = rows(H)
	f = 1
	while (f <= nbasis)
		comp1 = COEF1[,f] * matrix(n2)'
		comp2 = COEF2[,f] * matrix(n1)'
		semimetric = semimetric + ( comp1 - comp2' )^2
 		f = f + 1
	endo
	semimetric = sqrt(semimetric)

endp

; --------------------------------------------------------------------
; --------------------------------------------------------------------

