; --------------------------------------------------------------------
; --------------------------------------------------------------------
; SEMI-METRIC Functional PCA
; --------------------------------------------------------------------
; --------------------------------------------------------------------

library("xplore")
library("nummath")

; --------------------------------------------------------------------
; --------------------------------------------------------------------

proc(semimetric) = SemiMetricPCA(data1, q, data2)

; --------------------------------------------------------------------
; q = dimension for the reduced dimensional space
; --------------------------------------------------------------------
	
	n1 = rows(data1)
	n2 = rows(data2)
	covariance = data1' * data1 / n1
	eigen = eigensm(covariance)
	eigenvectors = eigen.vectors[,1:q]
	component1 = data1 * eigenvectors
	component2 = data2 * eigenvectors
	semimetric = 0
	qq = 1
	while (qq <= q)
		comp1 = component1[,qq] * matrix(n2)'
		comp2 = component2[,qq] * matrix(n1)'
		semimetric = semimetric + ( comp1 - comp2' )^2
 		qq = qq + 1
	endo
	semimetric = sqrt(semimetric)

endp

; --------------------------------------------------------------------
; --------------------------------------------------------------------


