; --------------------------------------------------------------------
; --------------------------------------------------------------------
; B-SPLINE
; --------------------------------------------------------------------
; --------------------------------------------------------------------

proc(bsplinemat) = bspline(x,knots,ord,m)
        
;function bspline computes the values of B-spline basis functions with sequence of knots "knots" and order "ord"        
;x:points where the spline basis functions are computed
;knots:sequence of points of the knots of the spline functions
;ord:order of the splines functions, equal to degree-1
;m:order of derivative of the splines functions
;result:bsplinemat:matrix with dimensions size(x) times number of basis functions
;needs "xplore" library and "rep" function

; set some abbreviations:
nx=dim(x)
nk=dim(knots)
q=ord-1
ns=nk+ord-2

onenx = rep(1,nx)
oneord = rep(1,ord)
onens = rep(1,ns)

;augment knots sequence by adding knots at each end
knots=knots[1]*rep(1,q)|knots|knots[nk]*rep(1,q)
nbasis=dim(knots)-ord

ignored=sort(knots[1:nbasis]|x)
indice=order((knots[1:nbasis]|x)+0.00001*(1:(nbasis+nx)))
pointer=(order((indice>dim(knots[1:nbasis]))+0.00001*(1:(nbasis+nx))))[1+(nbasis+nx)-(sum(indice>dim(knots[1:nbasis]))):(nbasis+nx)]-(1:nx)
left=max(pointer~(ord*onenx),2)

;initialization of the spline array
temp=1|rep(0,q) 
b=rep(temp',(m+1)*nx)
nxs=(m+1)*(1:nx)

j=1
while (j<=ord-(m+1))
   saved=rep(0,nx)
   r=1
   while (r<=j)
      leftpr=left+r
      tr=knots[leftpr]-x
      tl=x-knots[leftpr-j]
      term=b[nxs,r]./(tr+tl)
      b[nxs,r]=saved+tr.*term
      saved=tl.*term
                r=r+1
   endo
   b[nxs,j+1]=saved
         j=j+1   
endo

jj=1
while (jj<=m)
   j=ord-(m+1)+jj 
   saved=rep(0,nx) 
   nxn=nxs-1
   r=1
   while (r<=j)
      leftpr=left+r
      tr=knots[leftpr]-x
      tl=x-knots[leftpr-j]
      term=b[nxs,r]./(tr+tl)
      b[nxn,r]=saved+tr.*term
      saved= tl.*term
      r=r+1
   endo
   b[nxn,j+1]=saved 
   nxs=nxn
   jj=jj+1
endo

jj=m
while (jj>=1)
   j=ord-jj
   temp=(jj:m)*onenx'+rep(1,m+1-jj)*nxn' 
   nxs=reshape(temp,#((m-jj+1)*nx,1))
   r=j
   while (r>=1)
      leftpr=left+r
      temp=rep(1,m+1-jj)*((knots[leftpr]-knots[leftpr-j])./j)'
      b[nxs,r]=-b[nxs,r]./(reshape(temp,#(rows(temp)*cols(temp),1)))
      b[nxs,r+1]=b[nxs,r+1]-b[nxs,r]
      r=r-1
   endo
jj=jj-1
endo

width=max(ns~nbasis,2)+2*q
cc=rep(0,nx*width)
index=(1-nx:0)*oneord'+nx*(left*oneord'+onenx*(-q:0)')
cc[reshape(index,#(rows(index)*cols(index),1))]=reshape(b[(m+1)*(1:nx),],#(rows(b[(m+1)*(1:nx),])*cols(b[(m+1)*(1:nx),]),1))
bsplinemat=reshape(cc[1:nx*ns],#(nx,ns))

endp

; --------------------------------------------------------------------
; --------------------------------------------------------------------

proc(A,B,G)=bsplineini(X,nknots,ord,m)

;the arguments of the function are:
;X:data matrix (size p times n) with n=number of curves and p=number of design points
;nknots:number of interior knots of the splines functions (the knots will be equidistant)
;ord:order of the splines functions, equal to degree-1
;m:order of derivative of the splines functions
;the values of the function are:
;A:matrix of the coordinates of the curves in the B-splines basis
;B:matrix of the B-splines values at the design points
;G:Gram matrix of the B-splines derivatives of order m
;needs "xplore" library and "rep" and "bspline" functions

p=rows(X)
n=cols(X)
A=rep((rep(0,n))',nknots+ord)
x0=aseq(0,p,1/(p-1))
x=aseq(0,200,1/199)
knots=aseq(0,nknots+2,1/(nknots+1))

xdiff=diff(x)
D=bspline(x,knots,ord,m)
G1=D[2:200,]'*(D[2:200,].*xdiff)
G2=D[1:199,]'*(D[1:199,].*xdiff)
G=0.5*(G1+G2)
B=bspline(x0,knots,ord,0)
A=B'*X/p

endp

; --------------------------------------------------------------------
; --------------------------------------------------------------------

proc(y) = rep(x,n)
;repeats n times the object x
        if (n==1)
                y=x
        else
                i=1
                y=x
                while (i<n)
                        y=y|x
                        i=i+1
                endo
        endif
endp

; --------------------------------------------------------------------
; --------------------------------------------------------------------

