library("hazreg")
dat=read("tanakacy1.dat")
t = dat[,1]
delta = dat[,2]
{data,ties} = hazdat(t,delta)
{cil,kme,ciu} = hazkpm(data)
setsize(600,400)
plot1=createdisplay(1,1)
n = rows(data)
pm = (#(1,n+2)'+ (0:n))|(#(2*n+2,3*n+3)'+ (0:n))
cn = matrix(2*n+2)
ar = matrix(2*n+2)
th = matrix(2*n+2)
cilline = steps4plot(cil)
setmaskl(cilline, pm, cn, ar, th)
setmaskp(cilline, 4, 0, 8)
ciuline = steps4plot(ciu)
setmaskl(ciuline, pm, cn, ar, th)
setmaskp(ciuline, 4, 0, 8)
kmeline = steps4plot(kme, 0~1)
setmaskl(kmeline, pm, cn, ar, 2*th)
setmaskp(kmeline, 4, 0, 8)
show(plot1, 1, 1, cilline, kmeline, ciuline)  
setgopt(plot1, 1, 1, "xlabel","Months")
setgopt(plot1, 1, 1, "ylabel","Survival Function")
print (plot1,"kpmtanakacy1.ps")