proc()=XCSfda01()
; ---------------------------------------------------------------------
; EBook          XCS
; ---------------------------------------------------------------------
; See_also       Fouriertrans Fouriereval FDApca
; ---------------------------------------------------------------------
; Macro          XCSfda01
; ---------------------------------------------------------------------
; Description    Calculates the coefficient of functional data in applying 
;                a basis expansion by using Fourier series and evaluates the functional data.
;        The figure shows the temperature functions based on the evaluation.
; ---------------------------------------------------------------------
; Usage          XCSfda01() 
; ---------------------------------------------------------------------
; Author         Yoshihiro Yamanishi 010927.
; ---------------------------------------------------------------------

temp=read("dailtemp.dat")            ; read daily temperature data
nbasis = 30                          ; set the number of basis functions
tempcoef =  Fouriertrans(temp,nbasis); calculation of coefficient matrix
K = rows(tempcoef)                   ; number of basis functions in algorithm
nresol = 100                         ; number of grid points for evaluation
period = 365                         ; period
phi = Fouriereval(K,nresol,period)   ; evaluation of basis functions
tempfdval = tempcoef' * phi          ; evaluation of data functions
bp = grpcp (tempfdval,0)             ; parallel cordinates plot
dispfd  = createdisplay(1,1)         ; create display
show (dispfd, 1, 1, bp)              ; plots lines
setgopt(dispfd,1,1,"title","Temperature Functions","xvalue",0|1,"yvalue",0|1)
endp

library("math")
library("smoother")
XCSfda01()
