proc()=XCSfda03()
; ---------------------------------------------------------------------
; EBook          XCS
; ---------------------------------------------------------------------
; See_also       Fouriertrans Fouriereval FDApca
; ---------------------------------------------------------------------
; Macro          XCSfda03
; ---------------------------------------------------------------------
; Description    Carries out a penalized functional PCA when lambda=10000. 
;                Fourier series is used for evaluating the eigenfunctions.
;        The figure shows the PC weight functions based on the evaluation.
; ---------------------------------------------------------------------
; Usage          XCSfda03() 
; ---------------------------------------------------------------------
; Author         Yoshihiro Yamanishi 010927.
; ---------------------------------------------------------------------

temp=read("dailtemp.dat")            ; read daily temperature data
nbasis = 30                          ; set the number of basis functions
tempcoef =  Fouriertrans(temp,nbasis); calculation of coefficient matrix
period = 365                         ; period
lambda = 10000                       ; smoothing parameter
npc = 4                              ; number of principal components
tempfpcaresult = FDApca(tempcoef,period,lambda,npc); functional PCA
tempycoef = tempfpcaresult.harmcoef  ; coefficient for eigenfunctions
K   = rows(tempycoef)                ; number of basis functions in algorithm
nresol = 100                         ; number of grid points for evaluation
phi = Fouriereval(K,nresol,period)   ; evaluation of basis functions
tempxifdval = (tempycoef' * phi)'    ; evaluation of eigenfunctions
x  = ((1:nresol)-0.5)/(nresol/period); generates grid
z1 = setmask(x~tempxifdval[,1], "line", "black"); black line for PC1 weight
z2 = setmask(x~tempxifdval[,2], "line", "blue") ; blue  line for PC2 weight
z3 = setmask(x~tempxifdval[,3], "line", "red")  ; red   line for PC3 weight
z4 = setmask(x~tempxifdval[,4], "line", "green"); green line for PC4 weight
plot(z1, z2, z3, z4)                 ; plots lines
endp

library("math")
library("smoother")
XCSfda03()
