proc()=XCSfdaCov()
; ---------------------------------------------------------------------
; EBook          XCS
; ---------------------------------------------------------------------
; See_also       grfd, createfdbasis, data2fd
; ---------------------------------------------------------------------
; Macro          XCSfdaCov
; ---------------------------------------------------------------------
; Description    calculates and plots the cov function for temperature dataset using Fourier series basis
; ---------------------------------------------------------------------
; Usage          XCSfdaCov() 
; ---------------------------------------------------------------------
; Author         Michal Benko 040831
; ---------------------------------------------------------------------
endp

library("plot")
library("fda")
 y = read ("dailtemp.dat")
 tvec=#(1:365)/365
 fdb = createfdbasis ("fourier", #(0,1),31,1)
 fdtempf31=data2fd(y,tvec,fdb)
 fdavarf=evalfdacov(grid(0,1/30,31),fdtempf31)
freecolor()
              cl=grcolorscheme("color",10)
              createcolor(cl)
plot3d(3,grsurfacecol(fdavarf,cl,9))
setgopt(plot3disp,1,1,"title","Covariance Surface","border",0)
axeson()
XCSfdaCov()

